/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.bind;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.bind.Bind;
import org.eclipse.core.databinding.bind.steps.CommonSteps;
import org.eclipse.core.databinding.bind.steps.ListTwoWaySteps;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Test;

public class BindListTest
extends AbstractDefaultRealmTestCase {
    @Test
    public void oneWayBindingsCreated() {
        WritableList target = new WritableList();
        WritableList model = new WritableList();
        DataBindingContext context = new DataBindingContext();
        Binding binding = ((CommonSteps.OneWayConfigAndFromStep)Bind.oneWay().modelToTarget()).from((IObservableList)target).to((IObservableList)model).bind(context);
        Assert.assertTrue((boolean)context.getBindings().contains((Object)binding));
        Assert.assertSame((Object)target, (Object)binding.getModel());
        Assert.assertSame((Object)model, (Object)binding.getTarget());
    }

    @Test
    public void twoWayBindingsCreated() {
        WritableList target = new WritableList();
        WritableList model = new WritableList();
        DataBindingContext context = new DataBindingContext();
        Binding binding = ((CommonSteps.TwoWayConfigAndFromStep)Bind.twoWay().modelToTarget()).from((IObservableList)model).to((IObservableList)target).bind(context);
        Assert.assertTrue((boolean)context.getBindings().contains((Object)binding));
        Assert.assertSame((Object)target, (Object)binding.getTarget());
        Assert.assertSame((Object)model, (Object)binding.getModel());
    }

    @Test
    public void defaultDirectionIsTargetToModel() {
        WritableList target = new WritableList();
        WritableList model = new WritableList();
        Binding binding = Bind.oneWay().from((IObservableList)target).to((IObservableList)model).bindWithNewContext();
        Assert.assertSame((Object)target, (Object)binding.getTarget());
        Assert.assertSame((Object)model, (Object)binding.getModel());
    }

    @Test
    public void oneWayUpdate() {
        WritableList target = new WritableList();
        WritableList model = new WritableList();
        Bind.oneWay().from((IObservableList)target).to((IObservableList)model).bindWithNewContext();
        target.add((Object)"test1");
        Assert.assertTrue((boolean)model.contains((Object)"test1"));
        model.add((Object)"test2");
        Assert.assertFalse((boolean)target.contains((Object)"test2"));
    }

    @Test
    public void twoWayUpdate() {
        WritableList target = new WritableList();
        WritableList model = new WritableList();
        Bind.twoWay().from((IObservableList)target).to((IObservableList)model).bindWithNewContext();
        target.add((Object)"test1");
        Assert.assertTrue((boolean)model.contains((Object)"test1"));
        model.add((Object)"test2");
        Assert.assertTrue((boolean)target.contains((Object)"test2"));
    }

    @Test
    public void setListTwice() {
        WritableList target = new WritableList();
        WritableList model = new WritableList();
        Assert.assertThrows(IllegalStateException.class, () -> {
            CommonSteps.WriteConfigStep writeConfigStep = ((ListTwoWaySteps.ListTwoWayBindConfigStep)Bind.twoWay().from((IObservableList)model).to((IObservableList)target).updateOnlyOnRequest()).updateOnlyOnRequest();
        });
    }

    @Test
    public void setNull() {
        Assert.assertThrows(NullPointerException.class, () -> {
            ListTwoWaySteps.ListTwoWayConvertToStep listTwoWayConvertToStep = Bind.twoWay().from(null);
        });
    }

    @Test
    public void oneWayConverter() {
        WritableList target = new WritableList();
        WritableList model = new WritableList();
        Bind.oneWay().from((IObservableList)target).convertTo(IConverter.create(Integer::parseInt)).to((IObservableList)model).bindWithNewContext();
        target.add((Object)"1");
        Assert.assertTrue((boolean)model.contains((Object)1));
    }

    @Test
    public void twoWayConverter() {
        WritableList target = new WritableList();
        WritableList model = new WritableList();
        Bind.twoWay().from((IObservableList)target).convertTo(IConverter.create(Integer::parseInt)).convertFrom(IConverter.create(i -> i.toString())).to((IObservableList)model).bindWithNewContext();
        target.add((Object)"1");
        Assert.assertTrue((boolean)model.contains((Object)1));
        model.add((Object)2);
        Assert.assertTrue((boolean)target.contains((Object)"2"));
    }

    @Test
    public void twoWayDefaultConverter() {
        WritableList target = WritableList.withElementType(String.class);
        WritableList model = WritableList.withElementType(Integer.class);
        Bind.twoWay().from((IObservableList)target).defaultConvert().to((IObservableList)model).bindWithNewContext();
        target.add((Object)"1");
        Assert.assertTrue((boolean)model.contains((Object)1));
        model.add((Object)2);
        Assert.assertTrue((boolean)target.contains((Object)"2"));
    }

    @Test
    public void oneWayDefaultConverter() {
        WritableList target = WritableList.withElementType(String.class);
        WritableList model = WritableList.withElementType(Integer.class);
        Bind.oneWay().from((IObservableList)target).defaultConvert().to((IObservableList)model).bindWithNewContext();
        target.add((Object)"1");
        Assert.assertTrue((boolean)model.contains((Object)1));
        model.add((Object)2);
        Assert.assertFalse((boolean)target.contains((Object)"2"));
    }

    @Test
    public void updateOnlyOnRequest() {
        WritableList target = new WritableList();
        WritableList model = new WritableList();
        DataBindingContext context = new DataBindingContext();
        ((ListTwoWaySteps.ListTwoWayBindConfigStep)Bind.twoWay().from((IObservableList)target).to((IObservableList)model).updateOnlyOnRequest()).bind(context);
        target.add((Object)"test");
        Assert.assertFalse((boolean)model.contains((Object)"test"));
        context.updateModels();
        Assert.assertTrue((boolean)model.contains((Object)"test"));
    }
}

