/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.bind;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.bind.Bind;
import org.eclipse.core.databinding.bind.steps.CommonSteps;
import org.eclipse.core.databinding.bind.steps.SetTwoWaySteps;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Test;

public class BindSetTest
extends AbstractDefaultRealmTestCase {
    @Test
    public void oneWayBindingsCreated() {
        WritableSet target = new WritableSet();
        WritableSet model = new WritableSet();
        DataBindingContext context = new DataBindingContext();
        Binding binding = ((CommonSteps.OneWayConfigAndFromStep)Bind.oneWay().modelToTarget()).from((IObservableSet)target).to((IObservableSet)model).bind(context);
        Assert.assertTrue((boolean)context.getBindings().contains((Object)binding));
        Assert.assertSame((Object)target, (Object)binding.getModel());
        Assert.assertSame((Object)model, (Object)binding.getTarget());
    }

    @Test
    public void twoWayBindingsCreated() {
        WritableSet target = new WritableSet();
        WritableSet model = new WritableSet();
        DataBindingContext context = new DataBindingContext();
        Binding binding = ((CommonSteps.TwoWayConfigAndFromStep)Bind.twoWay().modelToTarget()).from((IObservableSet)model).to((IObservableSet)target).bind(context);
        Assert.assertTrue((boolean)context.getBindings().contains((Object)binding));
        Assert.assertSame((Object)target, (Object)binding.getTarget());
        Assert.assertSame((Object)model, (Object)binding.getModel());
    }

    @Test
    public void defaultDirectionIsTargetToModel() {
        WritableSet target = new WritableSet();
        WritableSet model = new WritableSet();
        Binding binding = Bind.oneWay().from((IObservableSet)target).to((IObservableSet)model).bindWithNewContext();
        Assert.assertSame((Object)target, (Object)binding.getTarget());
        Assert.assertSame((Object)model, (Object)binding.getModel());
    }

    @Test
    public void oneWayUpdate() {
        WritableSet target = new WritableSet();
        WritableSet model = new WritableSet();
        Bind.oneWay().from((IObservableSet)target).to((IObservableSet)model).bindWithNewContext();
        target.add((Object)"test1");
        Assert.assertTrue((boolean)model.contains((Object)"test1"));
        model.add((Object)"test2");
        Assert.assertFalse((boolean)target.contains((Object)"test2"));
    }

    @Test
    public void twoWayUpdate() {
        WritableSet target = new WritableSet();
        WritableSet model = new WritableSet();
        Bind.twoWay().from((IObservableSet)target).to((IObservableSet)model).bindWithNewContext();
        target.add((Object)"test1");
        Assert.assertTrue((boolean)model.contains((Object)"test1"));
        model.add((Object)"test2");
        Assert.assertTrue((boolean)target.contains((Object)"test2"));
    }

    @Test
    public void setSetTwice() {
        WritableSet target = new WritableSet();
        WritableSet model = new WritableSet();
        Assert.assertThrows(IllegalStateException.class, () -> {
            CommonSteps.WriteConfigStep writeConfigStep = ((SetTwoWaySteps.SetTwoWayBindConfigStep)Bind.twoWay().from((IObservableSet)model).to((IObservableSet)target).updateOnlyOnRequest()).updateOnlyOnRequest();
        });
    }

    @Test
    public void setNull() {
        Assert.assertThrows(NullPointerException.class, () -> {
            SetTwoWaySteps.SetTwoWayConvertToStep setTwoWayConvertToStep = Bind.twoWay().from(null);
        });
    }

    @Test
    public void oneWayConverter() {
        WritableSet target = new WritableSet();
        WritableSet model = new WritableSet();
        Bind.oneWay().from((IObservableSet)target).convertTo(IConverter.create(Integer::parseInt)).to((IObservableSet)model).bindWithNewContext();
        target.add((Object)"1");
        Assert.assertTrue((boolean)model.contains((Object)1));
    }

    @Test
    public void twoWayConverter() {
        WritableSet target = new WritableSet();
        WritableSet model = new WritableSet();
        Bind.twoWay().from((IObservableSet)target).convertTo(IConverter.create(Integer::parseInt)).convertFrom(IConverter.create(i -> i.toString())).to((IObservableSet)model).bindWithNewContext();
        target.add((Object)"1");
        Assert.assertTrue((boolean)model.contains((Object)1));
        model.add((Object)2);
        Assert.assertTrue((boolean)target.contains((Object)"2"));
    }

    @Test
    public void twoWayDefaultConverter() {
        WritableSet target = WritableSet.withElementType(String.class);
        WritableSet model = WritableSet.withElementType(Integer.class);
        Bind.twoWay().from((IObservableSet)target).defaultConvert().to((IObservableSet)model).bindWithNewContext();
        target.add((Object)"1");
        Assert.assertTrue((boolean)model.contains((Object)1));
        model.add((Object)2);
        Assert.assertTrue((boolean)target.contains((Object)"2"));
    }

    @Test
    public void oneWayDefaultConverter() {
        WritableSet target = WritableSet.withElementType(String.class);
        WritableSet model = WritableSet.withElementType(Integer.class);
        Bind.oneWay().from((IObservableSet)target).defaultConvert().to((IObservableSet)model).bindWithNewContext();
        target.add((Object)"1");
        Assert.assertTrue((boolean)model.contains((Object)1));
        model.add((Object)2);
        Assert.assertFalse((boolean)target.contains((Object)"2"));
    }

    @Test
    public void updateOnlyOnRequest() {
        WritableSet target = new WritableSet();
        WritableSet model = new WritableSet();
        DataBindingContext context = new DataBindingContext();
        ((SetTwoWaySteps.SetTwoWayBindConfigStep)Bind.twoWay().from((IObservableSet)target).to((IObservableSet)model).updateOnlyOnRequest()).bind(context);
        target.add((Object)"test");
        Assert.assertFalse((boolean)model.contains((Object)"test"));
        context.updateModels();
        Assert.assertTrue((boolean)model.contains((Object)"test"));
    }
}

