/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.bind;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.bind.Bind;
import org.eclipse.core.databinding.bind.steps.CommonSteps;
import org.eclipse.core.databinding.bind.steps.ValueCommonSteps;
import org.eclipse.core.databinding.bind.steps.ValueTwoWaySteps;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Test;

public class BindValueTest
extends AbstractDefaultRealmTestCase {
    @Test
    public void oneWayBindingsCreated() {
        WritableValue target = new WritableValue();
        WritableValue model = new WritableValue();
        DataBindingContext context = new DataBindingContext();
        Binding binding = ((CommonSteps.OneWayConfigAndFromStep)Bind.oneWay().modelToTarget()).from((IObservableValue)target).to((IObservableValue)model).bind(context);
        Assert.assertTrue((boolean)context.getBindings().contains((Object)binding));
        Assert.assertSame((Object)target, (Object)binding.getModel());
        Assert.assertSame((Object)model, (Object)binding.getTarget());
    }

    @Test
    public void twoWayBindingsCreated() {
        WritableValue target = new WritableValue();
        WritableValue model = new WritableValue();
        DataBindingContext context = new DataBindingContext();
        Binding binding = ((CommonSteps.TwoWayConfigAndFromStep)Bind.twoWay().modelToTarget()).from((IObservableValue)model).to((IObservableValue)target).bind(context);
        Assert.assertTrue((boolean)context.getBindings().contains((Object)binding));
        Assert.assertSame((Object)target, (Object)binding.getTarget());
        Assert.assertSame((Object)model, (Object)binding.getModel());
    }

    @Test
    public void defaultDirectionIsTargetToModel() {
        WritableValue target = new WritableValue();
        WritableValue model = new WritableValue();
        Binding binding = Bind.oneWay().from((IObservableValue)target).to((IObservableValue)model).bindWithNewContext();
        Assert.assertSame((Object)target, (Object)binding.getTarget());
        Assert.assertSame((Object)model, (Object)binding.getModel());
    }

    @Test
    public void oneWayUpdate() {
        WritableValue target = new WritableValue();
        WritableValue model = new WritableValue();
        Bind.oneWay().from((IObservableValue)target).to((IObservableValue)model).bindWithNewContext();
        target.setValue((Object)"test1");
        Assert.assertEquals((Object)"test1", (Object)model.getValue());
        model.setValue((Object)"test2");
        Assert.assertEquals((Object)"test1", (Object)target.getValue());
    }

    @Test
    public void twoWayUpdate() {
        WritableValue target = new WritableValue();
        WritableValue model = new WritableValue();
        Bind.twoWay().from((IObservableValue)model).to((IObservableValue)target).bindWithNewContext();
        target.setValue((Object)"test1");
        Assert.assertEquals((Object)"test1", (Object)model.getValue());
        model.setValue((Object)"test2");
        Assert.assertEquals((Object)"test2", (Object)target.getValue());
    }

    @Test
    public void validators() {
        WritableValue target = new WritableValue();
        WritableValue model = new WritableValue();
        ArrayList interactions = new ArrayList();
        ((ValueTwoWaySteps.ValueTwoWayBindConfigStep)((ValueTwoWaySteps.ValueTwoWayBindConfigStep)((ValueTwoWaySteps.ValueTwoWayBindConfigStep)((ValueTwoWaySteps.ValueTwoWayConvertToStep)((ValueTwoWaySteps.ValueTwoWayConvertToStep)((ValueTwoWaySteps.ValueTwoWayConvertToStep)Bind.twoWay().from((IObservableValue)model).validateAfterGet(e -> {
            interactions.add(e + "1");
            return Status.OK_STATUS;
        })).validateAfterConvert(e -> {
            interactions.add(e + "2");
            return Status.OK_STATUS;
        })).validateBeforeSet(e -> {
            interactions.add(e + "3");
            return Status.OK_STATUS;
        })).to((IObservableValue)target).validateAfterGet(e -> {
            interactions.add(e + "4");
            return Status.OK_STATUS;
        })).validateAfterConvert(e -> {
            interactions.add(e + "5");
            return Status.OK_STATUS;
        })).validateBeforeSet(e -> {
            interactions.add(e + "6");
            return Status.OK_STATUS;
        })).bindWithNewContext();
        interactions.clear();
        model.setValue((Object)"model");
        Assert.assertEquals((Object)"model", (Object)target.getValue());
        Assert.assertEquals(List.of("model1", "model5", "model6"), interactions);
        interactions.clear();
        target.setValue((Object)"target");
        Assert.assertEquals((Object)"target", (Object)target.getValue());
        System.out.println(interactions);
        Assert.assertEquals(List.of("target4", "target2", "target3"), interactions);
    }

    @Test
    public void twoWayValidator() {
        WritableValue target = new WritableValue();
        WritableValue model = new WritableValue();
        ArrayList interactions = new ArrayList();
        ((ValueTwoWaySteps.ValueTwoWayBindConfigStep)((ValueTwoWaySteps.ValueTwoWayConvertToStep)Bind.twoWay().from((IObservableValue)target).validateTwoWay(e -> {
            interactions.add(e + "-from-end");
            return Status.OK_STATUS;
        })).to((IObservableValue)model).validateTwoWay(e -> {
            interactions.add(e + "-to-end");
            return Status.OK_STATUS;
        })).bindWithNewContext();
        interactions.clear();
        target.setValue((Object)"test1");
        Assert.assertEquals((Object)"test1", (Object)model.getValue());
        Assert.assertEquals(List.of("test1-from-end", "test1-to-end"), interactions);
        interactions.clear();
        model.setValue((Object)"test2");
        Assert.assertEquals((Object)"test2", (Object)target.getValue());
        Assert.assertEquals(List.of("test2-to-end", "test2-from-end"), interactions);
    }

    @Test
    public void setValueTwice() {
        WritableValue target = new WritableValue();
        WritableValue model = new WritableValue();
        Assert.assertThrows(IllegalStateException.class, () -> {
            ValueCommonSteps.ValueWriteConfigStep valueWriteConfigStep = ((ValueTwoWaySteps.ValueTwoWayBindConfigStep)Bind.twoWay().from((IObservableValue)model).to((IObservableValue)target).convertOnly()).convertOnly();
        });
    }

    @Test
    public void setNull() {
        Assert.assertThrows(NullPointerException.class, () -> {
            ValueTwoWaySteps.ValueTwoWayConvertToStep valueTwoWayConvertToStep = Bind.twoWay().from(null);
        });
    }

    @Test
    public void oneWayConverter() {
        WritableValue target = new WritableValue();
        WritableValue model = new WritableValue();
        Bind.oneWay().from((IObservableValue)target).convertTo(IConverter.create(Integer::parseInt)).to((IObservableValue)model).bindWithNewContext();
        target.setValue((Object)"1");
        Assert.assertEquals((long)1L, (long)((Integer)model.getValue()).intValue());
        model.setValue((Object)2);
        Assert.assertEquals((Object)"1", (Object)target.getValue());
    }

    @Test
    public void twoWayConverter() {
        WritableValue target = new WritableValue();
        WritableValue model = new WritableValue();
        Bind.twoWay().from((IObservableValue)target).convertTo(IConverter.create(Integer::parseInt)).convertFrom(IConverter.create(i -> i.toString())).to((IObservableValue)model).bindWithNewContext();
        target.setValue((Object)"1");
        Assert.assertEquals((long)1L, (long)((Integer)model.getValue()).intValue());
        model.setValue((Object)2);
        Assert.assertEquals((Object)"2", (Object)target.getValue());
    }

    @Test
    public void twoWayDefaultConverter() {
        WritableValue target = new WritableValue(null, String.class);
        WritableValue model = new WritableValue(null, Integer.class);
        Bind.twoWay().from((IObservableValue)target).defaultConvert().to((IObservableValue)model).bindWithNewContext();
        target.setValue((Object)"1");
        Assert.assertEquals((long)1L, (long)((Integer)model.getValue()).intValue());
        model.setValue((Object)2);
        Assert.assertEquals((Object)"2", (Object)target.getValue());
    }

    @Test
    public void oneWayDefaultConverter() {
        WritableValue target = new WritableValue(null, String.class);
        WritableValue model = new WritableValue(null, Integer.class);
        Bind.oneWay().from((IObservableValue)target).defaultConvert().to((IObservableValue)model).bindWithNewContext();
        target.setValue((Object)"1");
        Assert.assertEquals((long)1L, (long)((Integer)model.getValue()).intValue());
        model.setValue((Object)2);
        Assert.assertEquals((Object)"1", (Object)target.getValue());
    }

    @Test
    public void updateOnlyOnRequest() {
        WritableValue target = new WritableValue();
        WritableValue model = new WritableValue();
        DataBindingContext context = new DataBindingContext();
        ((ValueTwoWaySteps.ValueTwoWayBindConfigStep)Bind.twoWay().from((IObservableValue)target).to((IObservableValue)model).updateOnlyOnRequest()).bind(context);
        target.setValue((Object)"test");
        Assert.assertEquals(null, (Object)model.getValue());
        context.updateModels();
        Assert.assertEquals((Object)"test", (Object)model.getValue());
    }

    @Test
    public void convertOnly() {
        WritableValue target = new WritableValue();
        WritableValue model = new WritableValue();
        ArrayList interactions = new ArrayList();
        ((ValueTwoWaySteps.ValueTwoWayBindConfigStep)Bind.twoWay().from((IObservableValue)target).convertTo(IConverter.create(e -> {
            interactions.add(e + "-to");
            return e + "-to";
        })).convertFrom(IConverter.create(e -> {
            interactions.add(e + "-from");
            return e + "-from";
        })).to((IObservableValue)model).convertOnly()).bindWithNewContext();
        interactions.clear();
        target.setValue((Object)"test1");
        Assert.assertEquals(null, (Object)model.getValue());
        model.setValue((Object)"test2");
        Assert.assertEquals((Object)"test2-from", (Object)target.getValue());
        Assert.assertEquals(List.of("test1-to", "test2-from"), interactions);
    }
}

