/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.conversion;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.Format;
import org.eclipse.core.databinding.conversion.text.NumberToStringConverter;
import org.eclipse.core.internal.databinding.conversion.StringToNumberParser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NumberToStringConverterTest {
    private Format numberFormat;
    private Format integerFormat;

    @Before
    public void setUp() throws Exception {
        this.numberFormat = StringToNumberParser.getDefaultNumberFormat();
        this.integerFormat = StringToNumberParser.getDefaultIntegerFormat();
    }

    @Test
    public void testFromTypes() throws Exception {
        Assert.assertEquals((String)"Integer.class", Integer.class, (Object)NumberToStringConverter.fromInteger((boolean)false).getFromType());
        Assert.assertEquals((String)"Integer.TYPE", Integer.TYPE, (Object)NumberToStringConverter.fromInteger((boolean)true).getFromType());
        Assert.assertEquals((String)"Double.class", Double.class, (Object)NumberToStringConverter.fromDouble((boolean)false).getFromType());
        Assert.assertEquals((String)"Double.TYPE", Double.TYPE, (Object)NumberToStringConverter.fromDouble((boolean)true).getFromType());
        Assert.assertEquals((String)"Long.class", Long.class, (Object)NumberToStringConverter.fromLong((boolean)false).getFromType());
        Assert.assertEquals((String)"Long.TYPE", Long.TYPE, (Object)NumberToStringConverter.fromLong((boolean)true).getFromType());
        Assert.assertEquals((String)"Float.class", Float.class, (Object)NumberToStringConverter.fromFloat((boolean)false).getFromType());
        Assert.assertEquals((String)"Float.TYPE", Float.TYPE, (Object)NumberToStringConverter.fromFloat((boolean)true).getFromType());
        Assert.assertEquals((String)"BigInteger.class", BigInteger.class, (Object)NumberToStringConverter.fromBigInteger().getFromType());
        Assert.assertEquals((String)"BigDecimal.class", BigDecimal.class, (Object)NumberToStringConverter.fromBigDecimal().getFromType());
        Assert.assertEquals((String)"Short.class", Short.class, (Object)NumberToStringConverter.fromShort((boolean)false).getFromType());
        Assert.assertEquals((String)"Byte.class", Byte.class, (Object)NumberToStringConverter.fromByte((boolean)false).getFromType());
    }

    @Test
    public void testToTypeIsStringClass() throws Exception {
        Assert.assertEquals(String.class, (Object)NumberToStringConverter.fromInteger((boolean)false).getToType());
    }

    @Test
    public void testConvertIntegerToString() throws Exception {
        Integer input = 1000;
        String expected = this.integerFormat.format(input.longValue());
        NumberToStringConverter converter = NumberToStringConverter.fromInteger((boolean)false);
        String result = converter.convert((Object)input);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testConvertDoubleToString() throws Exception {
        Double input = 1000.1;
        String expected = this.numberFormat.format((double)input);
        NumberToStringConverter converter = NumberToStringConverter.fromDouble((boolean)false);
        String result = converter.convert((Object)input);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testConvertFloatToString() throws Exception {
        Float input = Float.valueOf(1000.1f);
        String expected = this.numberFormat.format(Float.valueOf(input.floatValue()));
        NumberToStringConverter converter = NumberToStringConverter.fromFloat((boolean)false);
        String result = converter.convert((Object)input);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testConvertLongToString() throws Exception {
        Long input = 1000L;
        String expected = this.integerFormat.format((long)input);
        NumberToStringConverter converter = NumberToStringConverter.fromLong((boolean)false);
        String result = converter.convert((Object)input);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testConvertBigIntegerToString() throws Exception {
        BigInteger input = BigInteger.valueOf(1000L);
        String expected = this.integerFormat.format(input);
        NumberToStringConverter converter = NumberToStringConverter.fromBigInteger();
        String result = converter.convert((Object)input);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testConvertBigDecimalToString() throws Exception {
        NumberToStringConverter converter = NumberToStringConverter.fromBigDecimal();
        BigDecimal input = new BigDecimal("100.23");
        String expected = this.numberFormat.format(input);
        String result = converter.convert((Object)input);
        Assert.assertEquals((String)"Non-integer BigDecimal", (Object)expected, (Object)result);
        input = BigDecimal.valueOf(2147483747L);
        expected = this.numberFormat.format(input);
        result = converter.convert((Object)input);
        Assert.assertEquals((String)"Integral BigDecimal in long range", (Object)expected, (Object)result);
        input = new BigDecimal(BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.valueOf(100L)));
        expected = this.numberFormat.format(input);
        result = converter.convert((Object)input);
        Assert.assertEquals((String)"Integral BigDecimal in BigInteger range", (Object)expected, (Object)result);
        input = new BigDecimal("100404101.233456783456788934567893456789231982001345678234567890");
        expected = this.numberFormat.format(input);
        result = converter.convert((Object)input);
        Assert.assertEquals((String)"High-precision BigDecimal", (Object)expected, (Object)result);
    }

    @Test
    public void testNullSourceConvertsToEmptyString() throws Exception {
        NumberToStringConverter converter = NumberToStringConverter.fromInteger((boolean)false);
        Assert.assertEquals((Object)"", (Object)converter.convert(null));
    }
}

