/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable;

import org.eclipse.core.databinding.observable.AbstractObservable;
import org.eclipse.core.databinding.observable.DecoratingObservable;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.databinding.conformance.util.DisposeEventTracker;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DecoratingObservableTest
extends AbstractDefaultRealmTestCase {
    private IObservable decorated;
    private DecoratingObservable decorator;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.decorated = new ObservableStub(Realm.getDefault());
        this.decorator = new DecoratingObservable(this.decorated, false);
    }

    @Test
    public void testDisposeDecorated_DisposesDecorator() {
        DisposeEventTracker tracker = DisposeEventTracker.observe((IObservable)this.decorator);
        Assert.assertFalse((boolean)this.decorator.isDisposed());
        this.decorated.dispose();
        Assert.assertEquals((long)1L, (long)tracker.count);
        Assert.assertTrue((boolean)this.decorator.isDisposed());
    }

    static class ObservableStub
    extends AbstractObservable {
        public ObservableStub(Realm realm) {
            super(realm);
        }

        public boolean isStale() {
            return false;
        }
    }
}

