/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.databinding.observable.AbstractObservable;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.util.Policy;
import org.eclipse.core.internal.databinding.IdentitySet;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Test;

public class ObservableTrackerTest
extends AbstractDefaultRealmTestCase {
    @Test
    public void testRunAndMonitor_GetterCalled() throws Exception {
        ObservableStub observable = new ObservableStub();
        IObservable[] result = ObservableTracker.runAndMonitor(() -> ObservableTrackerTest.lambda$0((IObservable)observable), null, null);
        Assert.assertEquals((long)1L, (long)result.length);
        Assert.assertSame((Object)((Object)observable), (Object)result[0]);
    }

    @Test
    public void testGetterCalled_ObservableDisposed() throws Exception {
        ObservableStub observable = new ObservableStub();
        observable.dispose();
        Assert.assertThrows(AssertionFailedException.class, () -> ObservableTrackerTest.lambda$1((IObservable)observable));
    }

    @Test
    public void testGetterCalled_ObservableRealmNotCurrent() throws Exception {
        ObservableStub observable = new ObservableStub((Realm)new CurrentRealm(false));
        Assert.assertThrows(AssertionFailedException.class, () -> ObservableTrackerTest.lambda$2((IObservable)observable));
    }

    @Test
    public void testRunAndCollect() throws Exception {
        IObservable[] created = new IObservable[1];
        IObservable[] collected = ObservableTracker.runAndCollect(() -> {
            ObservableStub observableStub = new ObservableStub();
        });
        Assert.assertEquals((long)1L, (long)collected.length);
        Assert.assertSame((Object)created[0], (Object)collected[0]);
    }

    @Test
    public void testRunAndIgnore_RunAndMonitor() throws Exception {
        ObservableStub observable = new ObservableStub();
        IObservable[] result = ObservableTracker.runAndMonitor(() -> ObservableTrackerTest.lambda$4((IObservable)observable), null, null);
        Assert.assertEquals((long)0L, (long)result.length);
    }

    @Test
    public void testRunAndIgnore_RunAndCollect() throws Exception {
        IObservable[] result = ObservableTracker.runAndCollect(() -> ObservableTracker.runAndIgnore(ObservableStub::new));
        Assert.assertEquals((long)0L, (long)result.length);
    }

    @Test
    public void testSetIgnore_RunAndMonitor() throws Exception {
        ObservableStub observable = new ObservableStub();
        IObservable[] result = ObservableTracker.runAndMonitor(() -> ObservableTrackerTest.lambda$8((IObservable)observable), null, null);
        Assert.assertEquals((long)0L, (long)result.length);
    }

    @Test
    public void testSetIgnore_RunAndCollect() throws Exception {
        IObservable[] result = ObservableTracker.runAndCollect(() -> {
            ObservableTracker.setIgnore((boolean)true);
            new ObservableStub();
            ObservableTracker.setIgnore((boolean)false);
        });
        Assert.assertEquals((long)0L, (long)result.length);
    }

    @Test
    public void testSetIgnore_Nested_RunAndCollect() throws Exception {
        ArrayList list = new ArrayList();
        IdentitySet collected = new IdentitySet(Arrays.asList(ObservableTracker.runAndCollect(() -> {
            list.add(new ObservableStub());
            ObservableTracker.setIgnore((boolean)true);
            list.add(new ObservableStub());
            ObservableTracker.setIgnore((boolean)true);
            list.add(new ObservableStub());
            ObservableTracker.setIgnore((boolean)false);
            list.add(new ObservableStub());
            ObservableTracker.setIgnore((boolean)false);
            list.add(new ObservableStub());
        })));
        IdentitySet expected = new IdentitySet();
        expected.add((IObservable)list.get(0));
        expected.add((IObservable)list.get(4));
        Assert.assertEquals((Object)expected, (Object)collected);
    }

    @Test
    public void testSetIgnore_Nested_RunAndMonitor() throws Exception {
        IObservable[] observables = new IObservable[]{new ObservableStub(), new ObservableStub(), new ObservableStub(), new ObservableStub(), new ObservableStub()};
        IdentitySet result = new IdentitySet(Arrays.asList(ObservableTracker.runAndMonitor(() -> {
            ObservableTracker.getterCalled((IObservable)observables[0]);
            ObservableTracker.setIgnore((boolean)true);
            ObservableTracker.getterCalled((IObservable)observables[1]);
            ObservableTracker.setIgnore((boolean)true);
            ObservableTracker.getterCalled((IObservable)observables[2]);
            ObservableTracker.setIgnore((boolean)false);
            ObservableTracker.getterCalled((IObservable)observables[3]);
            ObservableTracker.setIgnore((boolean)false);
            ObservableTracker.getterCalled((IObservable)observables[4]);
        }, null, null)));
        IdentitySet expected = new IdentitySet();
        expected.add(observables[0]);
        expected.add(observables[4]);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testSetIgnore_RunAndMonitor_UnmatchedIgnore_LogsError() {
        ArrayList log = new ArrayList();
        Policy.setLog(status -> {
            boolean bl = log.add(status);
        });
        ObservableTracker.runAndMonitor(() -> ObservableTracker.setIgnore((boolean)true), null, null);
        Assert.assertEquals((long)1L, (long)log.size());
        IStatus status2 = (IStatus)log.get(0);
        Assert.assertEquals((long)4L, (long)status2.getSeverity());
        Assert.assertTrue((boolean)status2.getMessage().contains("setIgnore"));
    }

    @Test
    public void testSetIgnore_RunAndCollect_UnmatchedIgnore_LogsError() {
        ArrayList log = new ArrayList();
        Policy.setLog(status -> {
            boolean bl = log.add(status);
        });
        ObservableTracker.runAndCollect(() -> ObservableTracker.setIgnore((boolean)true));
        Assert.assertEquals((long)1L, (long)log.size());
        IStatus status2 = (IStatus)log.get(0);
        Assert.assertEquals((long)4L, (long)status2.getSeverity());
        Assert.assertTrue((boolean)status2.getMessage().contains("setIgnore"));
    }

    @Test
    public void testSetIgnore_UnmatchedUnignore() {
        Assert.assertThrows(IllegalStateException.class, () -> ObservableTracker.setIgnore((boolean)false));
    }

    private static /* synthetic */ void lambda$0(IObservable iObservable) {
        ObservableTracker.getterCalled((IObservable)iObservable);
    }

    private static /* synthetic */ void lambda$1(IObservable iObservable) throws Throwable {
        ObservableTracker.getterCalled((IObservable)iObservable);
    }

    private static /* synthetic */ void lambda$2(IObservable iObservable) throws Throwable {
        ObservableTracker.getterCalled((IObservable)iObservable);
    }

    private static /* synthetic */ void lambda$4(IObservable iObservable) {
        ObservableTracker.runAndIgnore(() -> ObservableTracker.getterCalled((IObservable)iObservable));
    }

    private static /* synthetic */ void lambda$8(IObservable iObservable) {
        ObservableTracker.setIgnore((boolean)true);
        ObservableTracker.getterCalled((IObservable)iObservable);
        ObservableTracker.setIgnore((boolean)false);
    }

    public static class ObservableStub
    extends AbstractObservable {
        public ObservableStub() {
            this(Realm.getDefault());
        }

        public ObservableStub(Realm realm) {
            super(realm);
        }

        public boolean isStale() {
            return false;
        }
    }
}

