/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.AbstractObservableList;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.jface.databinding.conformance.ObservableListContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.RealmTester;
import org.eclipse.jface.databinding.conformance.util.TestCollection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AbstractObservableListTest {
    private AbstractObservableListStub<Object> list;

    @Before
    public void setUp() throws Exception {
        RealmTester.setDefault((Realm)new CurrentRealm(true));
        this.list = new AbstractObservableListStub();
    }

    @After
    public void tearDown() throws Exception {
        RealmTester.setDefault(null);
    }

    @Test
    public void testFireChangeRealmChecks() throws Exception {
        RealmTester.exerciseCurrent(() -> this.list.fireChange());
    }

    @Test
    public void testFireStaleRealmChecks() throws Exception {
        RealmTester.exerciseCurrent(() -> this.list.fireStale());
    }

    @Test
    public void testFireListChangeRealmChecks() throws Exception {
        RealmTester.exerciseCurrent(() -> this.list.fireListChange(null));
    }

    @Test
    public void testMove_FiresListChanges() throws Exception {
        this.list = new MutableObservableListStub<Object>();
        Object element = new Object();
        this.list.add(element);
        this.list.add(new Object());
        ArrayList diffEntries = new ArrayList();
        this.list.addListChangeListener(event -> {
            boolean bl = diffEntries.addAll(Arrays.asList(event.diff.getDifferences()));
        });
        this.list.move(0, 1);
        Assert.assertEquals((long)2L, (long)diffEntries.size());
        ListDiffEntry entry = (ListDiffEntry)diffEntries.get(0);
        Assert.assertEquals((Object)element, (Object)entry.getElement());
        Assert.assertEquals((Object)false, (Object)entry.isAddition());
        Assert.assertEquals((long)0L, (long)entry.getPosition());
        entry = (ListDiffEntry)diffEntries.get(1);
        Assert.assertEquals((Object)element, (Object)entry.getElement());
        Assert.assertEquals((Object)true, (Object)entry.isAddition());
        Assert.assertEquals((long)1L, (long)entry.getPosition());
    }

    @Test
    public void testMove_MovesElement() throws Exception {
        this.list = new MutableObservableListStub<Object>();
        Object element0 = new Object();
        Object element1 = new Object();
        this.list.add(element0);
        this.list.add(element1);
        this.list.move(0, 1);
        Assert.assertEquals((Object)element1, (Object)this.list.get(0));
        Assert.assertEquals((Object)element0, (Object)this.list.get(1));
    }

    @Test
    public void testAddListChangeListener_AfterDispose() {
        this.list.dispose();
        this.list.addListChangeListener(event -> {});
    }

    @Test
    public void testRemoveListChangeListener_AfterDispose() {
        this.list.dispose();
        this.list.removeListChangeListener(event -> {});
    }

    @Test
    public void testAddChangeListener_AfterDispose() {
        this.list.dispose();
        this.list.addChangeListener(event -> {});
    }

    @Test
    public void testRemoveChangeListener_AfterDispose() {
        this.list.dispose();
        this.list.removeChangeListener(event -> {});
    }

    @Test
    public void testAddStaleListener_AfterDispose() {
        this.list.dispose();
        this.list.addStaleListener(staleEvent -> {});
    }

    @Test
    public void testRemoveStaleListener_AfterDispose() {
        this.list.dispose();
        this.list.removeStaleListener(staleEvent -> {});
    }

    @Test
    public void testAddDisposeListener_AfterDispose() {
        this.list.dispose();
        this.list.addDisposeListener(event -> {});
    }

    @Test
    public void testRemoveDisposeListener_AfterDispose() {
        this.list.dispose();
        this.list.removeDisposeListener(event -> {});
    }

    @Test
    public void testHasListeners_AfterDispose() {
        this.list.dispose();
        this.list.hasListeners();
    }

    public static void addConformanceTest(TestCollection suite) {
        suite.addTest(ObservableListContractTest.class, (Object)new Delegate());
    }

    static class AbstractObservableListStub<E>
    extends AbstractObservableList<E> {
        Object elementType;
        List<E> wrappedList;

        public AbstractObservableListStub() {
            this.wrappedList = new ArrayList();
        }

        public AbstractObservableListStub(Realm realm, List<E> list) {
            super(realm);
            this.wrappedList = list;
        }

        protected int doGetSize() {
            return this.wrappedList.size();
        }

        public E get(int index) {
            ObservableTracker.getterCalled((IObservable)this);
            return this.wrappedList.get(index);
        }

        public Object getElementType() {
            return this.elementType;
        }

        protected void fireChange() {
            super.fireChange();
        }

        protected void fireStale() {
            super.fireStale();
        }

        protected void fireListChange(ListDiff<E> diff) {
            super.fireListChange(diff);
        }

        protected synchronized boolean hasListeners() {
            return super.hasListeners();
        }
    }

    static class Delegate
    extends AbstractObservableCollectionContractDelegate<String> {
        Delegate() {
        }

        public IObservableCollection<String> createObservableCollection(Realm realm, int itemCount) {
            String[] items = new String[itemCount];
            int i = 0;
            while (i < itemCount) {
                items[i] = String.valueOf(i);
                ++i;
            }
            AbstractObservableListStub<String> observable = new AbstractObservableListStub<String>(realm, Arrays.asList(items));
            observable.elementType = String.class;
            return observable;
        }

        public Object getElementType(IObservableCollection<String> collection) {
            return String.class;
        }

        public void change(IObservable observable) {
            ((AbstractObservableListStub)observable).fireChange();
        }
    }

    static class MutableObservableListStub<E>
    extends AbstractObservableListStub<E> {
        MutableObservableListStub() {
        }

        public void add(int index, E element) {
            this.checkRealm();
            this.wrappedList.add(index, element);
            this.fireListChange(Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)index, (boolean)true, element)));
        }

        public E remove(int index) {
            this.checkRealm();
            Object element = this.wrappedList.remove(index);
            this.fireListChange(Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)index, (boolean)false, element)));
            return element;
        }
    }
}

