/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.list;

import java.util.ArrayList;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.DecoratingObservableList;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.jface.databinding.conformance.MutableObservableListContractTest;
import org.eclipse.jface.databinding.conformance.ObservableListContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.TestCollection;

public class DecoratingObservableListTest {
    public static void addConformanceTest(TestCollection suite) {
        suite.addTest(MutableObservableListContractTest.class, (Object)new Delegate());
        suite.addTest(ObservableListContractTest.class, (Object)new Delegate());
    }

    static class DecoratingObservableListStub<E>
    extends DecoratingObservableList<E> {
        IObservableList<E> decorated;

        DecoratingObservableListStub(IObservableList<E> decorated) {
            super(decorated, true);
            this.decorated = decorated;
        }
    }

    static class Delegate
    extends AbstractObservableCollectionContractDelegate<Object> {
        private final Object elementType = Object.class;

        Delegate() {
        }

        public IObservableCollection<Object> createObservableCollection(Realm realm, int elementCount) {
            WritableList wrappedList = new WritableList(realm, new ArrayList(), this.elementType);
            int i = 0;
            while (i < elementCount) {
                wrappedList.add(new Object());
                ++i;
            }
            return new DecoratingObservableListStub(wrappedList);
        }

        public Object createElement(IObservableCollection<Object> collection) {
            return new Object();
        }

        public Object getElementType(IObservableCollection<Object> collection) {
            return this.elementType;
        }

        public void change(IObservable observable) {
            ((DecoratingObservableListStub)observable).decorated.add(new Object());
        }
    }
}

