/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.list;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ListDiffTest {
    ListDiffVisitorStub visitor;

    @Before
    public void setUp() throws Exception {
        this.visitor = new ListDiffVisitorStub();
    }

    @Test
    public void testAccept_Add() {
        this.createListDiff(this.add(0, "element")).accept((ListDiffVisitor)this.visitor);
        Assert.assertEquals((Object)"add(0,element)", (Object)this.visitor.log);
    }

    @Test
    public void testAccept_Remove() {
        this.createListDiff(this.remove(0, "element")).accept((ListDiffVisitor)this.visitor);
        Assert.assertEquals((Object)"remove(0,element)", (Object)this.visitor.log);
    }

    @Test
    public void testAccept_MoveForward_RemoveBeforeAdd() {
        this.createListDiff(this.remove(0, "element"), this.add(1, "element")).accept((ListDiffVisitor)this.visitor);
        Assert.assertEquals((Object)"move(0,1,element)", (Object)this.visitor.log);
    }

    @Test
    public void testAccept_MoveForward_AddBeforeRemove() {
        this.createListDiff(this.add(2, "element"), this.remove(0, "element")).accept((ListDiffVisitor)this.visitor);
        Assert.assertEquals((Object)"move(0,1,element)", (Object)this.visitor.log);
    }

    @Test
    public void testAccept_MoveBackward_RemoveBeforeAdd() {
        this.createListDiff(this.remove(4, "element"), this.add(1, "element")).accept((ListDiffVisitor)this.visitor);
        Assert.assertEquals((Object)"move(4,1,element)", (Object)this.visitor.log);
    }

    @Test
    public void testAccept_MoveBackward_AddBeforeRemove() {
        this.createListDiff(this.add(1, "element"), this.remove(5, "element")).accept((ListDiffVisitor)this.visitor);
        Assert.assertEquals((Object)"move(4,1,element)", (Object)this.visitor.log);
    }

    @Test
    public void testAccept_Replace_RemoveBeforeAdd() {
        this.createListDiff(this.remove(0, "element0"), this.add(0, "element1")).accept((ListDiffVisitor)this.visitor);
        Assert.assertEquals((Object)"replace(0,element0,element1)", (Object)this.visitor.log);
    }

    @Test
    public void testAccept_Replace_AddBeforeRemove() {
        this.createListDiff(this.add(0, "element1"), this.remove(1, "element0")).accept((ListDiffVisitor)this.visitor);
        Assert.assertEquals((Object)"replace(0,element0,element1)", (Object)this.visitor.log);
    }

    @Test
    public void testAccept_AllPatterns() {
        this.createListDiff(this.remove(0, "element0"), this.add(0, "element1"), this.add(0, "element3"), this.remove(1, "element2"), this.remove(1, "element4"), this.add(2, "element5"), this.remove(5, "element6"), this.add(6, "element6"), this.add(7, "element6"), this.remove(5, "element6"), this.remove(12, "element7"), this.add(11, "element7"), this.add(11, "element7"), this.remove(13, "element7"), this.remove(11, "element8"), this.add(11, "element8"), this.add(12, "element9"), this.remove(12, "element9")).accept((ListDiffVisitor)this.visitor);
        Assert.assertEquals((Object)"replace(0,element0,element1), replace(0,element2,element3), remove(1,element4), add(2,element5), move(5,6,element6), move(5,6,element6), move(12,11,element7), move(12,11,element7), replace(11,element8,element8), add(12,element9), remove(12,element9)", (Object)this.visitor.log);
    }

    @Test
    public void testAccept_MoveDetectionUsesEqualityNotSameness() {
        String element0 = new String("element");
        String element1 = new String("element");
        Assert.assertNotSame((Object)element0, (Object)element1);
        Assert.assertEquals((Object)element0, (Object)element1);
        this.createListDiff(this.remove(0, element0), this.add(1, element1)).accept((ListDiffVisitor)this.visitor);
        Assert.assertEquals((Object)"move(0,1,element)", (Object)this.visitor.log);
    }

    private <E> ListDiffEntry<E> add(int index, E element) {
        return Diffs.createListDiffEntry((int)index, (boolean)true, element);
    }

    private <E> ListDiffEntry<E> remove(int index, E element) {
        return Diffs.createListDiffEntry((int)index, (boolean)false, element);
    }

    @SafeVarargs
    private final <E> ListDiff<E> createListDiff(ListDiffEntry<E> ... differences) {
        return Diffs.createListDiff(differences);
    }

    static class ListDiffVisitorStub
    extends ListDiffVisitor<Object> {
        String log = "";

        ListDiffVisitorStub() {
        }

        public void handleAdd(int index, Object element) {
            this.log("add(" + index + "," + String.valueOf(element) + ")");
        }

        public void handleRemove(int index, Object element) {
            this.log("remove(" + index + "," + String.valueOf(element) + ")");
        }

        public void handleMove(int oldIndex, int newIndex, Object element) {
            this.log("move(" + oldIndex + "," + newIndex + "," + String.valueOf(element) + ")");
        }

        public void handleReplace(int index, Object oldElement, Object newElement) {
            this.log("replace(" + index + "," + String.valueOf(oldElement) + "," + String.valueOf(newElement) + ")");
        }

        private void log(String message) {
            if (this.log.length() > 0) {
                this.log = String.valueOf(this.log) + ", ";
            }
            this.log = String.valueOf(this.log) + message;
        }
    }
}

