/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.list;

import java.util.ArrayList;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.list.MultiList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.jface.databinding.conformance.ObservableListContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.ListChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.TestCollection;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiListTest
extends AbstractDefaultRealmTestCase {
    MultiListStub multiList;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        WritableList[] lists = new WritableList[]{new WritableList(), new WritableList()};
        this.multiList = new MultiListStub(Realm.getDefault(), lists);
    }

    @Test
    public void testIsStale_FollowsSublist() {
        Assert.assertFalse((boolean)this.multiList.isStale());
        this.multiList.subLists[0].setStale(true);
        Assert.assertTrue((boolean)this.multiList.isStale());
        this.multiList.subLists[0].setStale(false);
        Assert.assertFalse((boolean)this.multiList.isStale());
    }

    @Test
    public void testDependency_FiresListChange() {
        ArrayList<Object> expectedList = new ArrayList<Object>();
        Assert.assertEquals(expectedList, (Object)((Object)this.multiList));
        Object element = new Object();
        expectedList.add(element);
        this.multiList.subLists[0].add(element);
        Assert.assertEquals(expectedList, (Object)((Object)this.multiList));
    }

    @Test
    public void testStaleEvent_NoFireEventIfAlreadyStale() {
        this.multiList.subLists[0].setStale(true);
        this.multiList.addStaleListener(staleEvent -> Assert.fail((String)"Should not fire stale when list is already dirty"));
        this.multiList.subLists[1].setStale(true);
    }

    @Test
    public void testModifySubList_FiresListChangeEventFromMultiList() {
        ListChangeEventTracker tracker = ListChangeEventTracker.observe((IObservableList)this.multiList);
        Object element0 = new Object();
        this.multiList.subLists[0].add(element0);
        Assert.assertEquals((long)1L, (long)tracker.count);
        ListDiffEntry[] differences = tracker.event.diff.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.length);
        this.assertEntry(differences[0], 0, true, element0);
        Object element1 = new Object();
        this.multiList.subLists[1].add(element1);
        Assert.assertEquals((long)2L, (long)tracker.count);
        differences = tracker.event.diff.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.length);
        this.assertEntry(differences[0], 1, true, element1);
        Object element2 = new Object();
        this.multiList.subLists[0].add(element2);
        Assert.assertEquals((long)3L, (long)tracker.count);
        differences = tracker.event.diff.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.length);
        this.assertEntry(differences[0], 1, true, element2);
    }

    private void assertEntry(ListDiffEntry<?> entry, int position, boolean addition, Object element) {
        Assert.assertEquals((Object)element, (Object)entry.getElement());
        Assert.assertEquals((Object)addition, (Object)entry.isAddition());
        Assert.assertEquals((long)position, (long)entry.getPosition());
    }

    public static void addConformanceTest(TestCollection suite) {
        suite.addTest(ObservableListContractTest.class, (Object)new Delegate());
    }

    static class Delegate
    extends AbstractObservableCollectionContractDelegate<Object> {
        Delegate() {
        }

        public IObservableCollection<Object> createObservableCollection(Realm realm, int elementCount) {
            WritableList[] subLists = new WritableList[]{new WritableList(realm), new WritableList(realm)};
            MultiListStub list = new MultiListStub(realm, subLists);
            int i = 0;
            while (i < elementCount) {
                list.subLists[0].add(this.createElement((IObservableCollection)list));
                ++i;
            }
            return list;
        }

        public void change(IObservable observable) {
            MultiListStub list = (MultiListStub)observable;
            list.subLists[0].add(new Object());
        }

        public void setStale(IObservable observable, boolean stale) {
            ((MultiListStub)observable).subLists[0].setStale(stale);
        }
    }

    private static class MultiListStub
    extends MultiList<Object> {
        WritableList<Object>[] subLists;

        MultiListStub(Realm realm, WritableList<Object>[] lists) {
            super(realm, lists);
            this.subLists = lists;
        }
    }
}

