/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.map;

import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.databinding.observable.map.BidiObservableMap;
import org.eclipse.core.databinding.observable.map.BidirectionalMap;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.WritableMap;
import org.eclipse.jface.databinding.conformance.util.ChangeEventTracker;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BidiObservableMapTest
extends AbstractDefaultRealmTestCase {
    private IObservableMap<Object, Object> wrappedMap;
    private BidiObservableMap<Object, Object> bidiMap;
    private Object key1;
    private Object key2;
    private Object value1;
    private Object value2;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.wrappedMap = new WritableMap();
        this.bidiMap = new BidiObservableMap(this.wrappedMap);
        this.key1 = new Object();
        this.key2 = new Object();
        this.value1 = new Object();
        this.value2 = new Object();
    }

    @Test
    public void testConstructor_NullArgument() {
        Assert.assertThrows(NullPointerException.class, () -> {
            BidirectionalMap bidirectionalMap = new BidirectionalMap(null);
        });
    }

    public void withAndWithoutListeners(Runnable runnable) throws Exception {
        runnable.run();
        this.tearDown();
        this.setUp();
        ChangeEventTracker.observe(this.wrappedMap);
        runnable.run();
    }

    @Test
    public void testGetKeys_Empty() throws Exception {
        this.withAndWithoutListeners(() -> Assert.assertEquals((Object)Collections.EMPTY_SET, (Object)this.bidiMap.getKeys(this.value1)));
    }

    @Test
    public void testGetKeys_NullKey() throws Exception {
        this.withAndWithoutListeners(() -> {
            this.wrappedMap.put(null, this.value1);
            Assert.assertEquals(Collections.singleton(null), (Object)this.bidiMap.getKeys(this.value1));
        });
    }

    @Test
    public void testGetKeys_NullValue() throws Exception {
        this.withAndWithoutListeners(() -> {
            this.wrappedMap.put(this.key1, null);
            Assert.assertEquals(Collections.singleton(this.key1), (Object)this.bidiMap.getKeys(null));
        });
    }

    @Test
    public void testGetKeys_SinglePut() throws Exception {
        this.withAndWithoutListeners(() -> {
            this.wrappedMap.put(this.key1, this.value1);
            Assert.assertEquals(Collections.singleton(this.key1), (Object)this.bidiMap.getKeys(this.value1));
        });
    }

    @Test
    public void testGetKeys_ReplaceValue() throws Exception {
        this.withAndWithoutListeners(() -> {
            this.wrappedMap.put(this.key1, this.value1);
            Assert.assertEquals(Collections.singleton(this.key1), (Object)this.bidiMap.getKeys(this.value1));
            Assert.assertEquals((Object)Collections.EMPTY_SET, (Object)this.bidiMap.getKeys(this.value2));
            this.wrappedMap.put(this.key1, this.value2);
            Assert.assertEquals((Object)Collections.EMPTY_SET, (Object)this.bidiMap.getKeys(this.value1));
            Assert.assertEquals(Collections.singleton(this.key1), (Object)this.bidiMap.getKeys(this.value2));
        });
    }

    @Test
    public void testGetKeys_MultipleKeysWithSameValue() throws Exception {
        this.withAndWithoutListeners(() -> {
            this.wrappedMap.put(this.key1, this.value1);
            this.wrappedMap.put(this.key2, this.value1);
            HashSet<Object> expected = new HashSet<Object>();
            expected.add(this.key1);
            expected.add(this.key2);
            Assert.assertEquals(expected, (Object)this.bidiMap.getKeys(this.value1));
        });
    }

    @Test
    public void testContainsValue_PutAndRemove() throws Exception {
        this.withAndWithoutListeners(() -> {
            Assert.assertFalse((boolean)this.bidiMap.containsValue(this.value1));
            this.wrappedMap.put(this.key1, this.value1);
            Assert.assertTrue((boolean)this.bidiMap.containsValue(this.value1));
            this.wrappedMap.put(this.key2, this.value1);
            Assert.assertTrue((boolean)this.bidiMap.containsValue(this.value1));
            this.wrappedMap.remove(this.key1);
            Assert.assertTrue((boolean)this.bidiMap.containsValue(this.value1));
            this.wrappedMap.remove(this.key2);
            Assert.assertFalse((boolean)this.bidiMap.containsValue(this.value1));
        });
    }
}

