/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.map;

import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.map.ComputedObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.tests.internal.databinding.beans.Bean;
import org.eclipse.jface.databinding.conformance.util.ChangeEventTracker;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ComputedObservableMapTest
extends AbstractDefaultRealmTestCase {
    private IObservableSet<Bean> keySet;
    private ComputedObservableMapStub map;
    private String propertyName;
    private Bean bean;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.keySet = new WritableSet();
        this.map = new ComputedObservableMapStub(this.keySet);
        this.propertyName = "value";
        this.bean = new Bean("a");
    }

    @Test
    public void testGet_ElementNotInKeySet() {
        Assert.assertNull((Object)this.map.get(this.bean));
    }

    @Test
    public void testGet_ElementInKeySet() {
        this.keySet.add((Object)this.bean);
        Assert.assertEquals((Object)"a", (Object)this.map.get(this.bean));
    }

    @Test
    public void testPut_ElementNotInKeySet() {
        Assert.assertNull((Object)this.map.put(this.bean, "b"));
        Assert.assertEquals((Object)"a", (Object)this.bean.getValue());
    }

    @Test
    public void testPut_ElementInKeySet() {
        this.keySet.add((Object)this.bean);
        Assert.assertEquals((Object)"a", (Object)this.map.put(this.bean, "b"));
        Assert.assertEquals((Object)"b", (Object)this.map.get(this.bean));
    }

    @Test
    public void testAddToKeySet_BeforeFirstListenerAdded_DoesNotAddListenerToKey() {
        Assert.assertFalse((boolean)this.bean.hasListeners(this.propertyName));
        this.keySet.add((Object)this.bean);
        Assert.assertFalse((boolean)this.bean.hasListeners(this.propertyName));
    }

    @Test
    public void testAddToKeySet_AfterFirstListenerAdded_AddsListenerToKey() {
        ChangeEventTracker.observe((IObservable)this.map);
        Assert.assertFalse((boolean)this.bean.hasListeners(this.propertyName));
        this.keySet.add((Object)this.bean);
        Assert.assertTrue((boolean)this.bean.hasListeners(this.propertyName));
    }

    @Test
    public void testRemoveFromKeySet_RemovesListenersFromKey() {
        ChangeEventTracker.observe((IObservable)this.map);
        this.keySet.add((Object)this.bean);
        Assert.assertTrue((boolean)this.bean.hasListeners(this.propertyName));
        this.keySet.remove((Object)this.bean);
        Assert.assertFalse((boolean)this.bean.hasListeners(this.propertyName));
    }

    @Test
    public void testRemoveLastListener_DoNotDiscardKeySet() {
        IChangeListener listener = event -> {};
        this.map.addChangeListener(listener);
        this.map.removeChangeListener(listener);
        this.keySet.add((Object)this.bean);
        Assert.assertEquals((long)1L, (long)this.map.size());
    }

    @Test
    public void testDispose_RemoveListenersFromKeySetElements() {
        ChangeEventTracker.observe((IObservable)this.map);
        this.keySet.add((Object)this.bean);
        Assert.assertTrue((boolean)this.bean.hasListeners(this.propertyName));
        this.map.dispose();
        Assert.assertFalse((boolean)this.bean.hasListeners(this.propertyName));
    }

    @Test
    public void testDisposeKeySet_DisposesMap() {
        Assert.assertFalse((boolean)this.map.isDisposed());
        this.keySet.dispose();
        Assert.assertTrue((boolean)this.map.isDisposed());
    }

    @Test
    public void testDisposeKeySet_RemoveListenersFromKeySetElements() {
        ChangeEventTracker.observe((IObservable)this.map);
        this.keySet.add((Object)this.bean);
        Assert.assertTrue((boolean)this.bean.hasListeners(this.propertyName));
        this.keySet.dispose();
        Assert.assertFalse((boolean)this.bean.hasListeners(this.propertyName));
    }

    static class ComputedObservableMapStub
    extends ComputedObservableMap<Bean, String> {
        private final PropertyChangeListener listener = evt -> this.fireSingleChange((Bean)evt.getSource(), (String)evt.getOldValue(), (String)evt.getNewValue());

        ComputedObservableMapStub(IObservableSet<Bean> keySet) {
            super(keySet);
        }

        protected String doGet(Bean key) {
            return key.getValue();
        }

        protected String doPut(Bean key, String value) {
            String result = this.doGet(key);
            key.setValue(value);
            return result;
        }

        protected void hookListener(Bean addedKey) {
            addedKey.addPropertyChangeListener(this.listener);
        }

        protected void unhookListener(Bean removedKey) {
            removedKey.removePropertyChangeListener(this.listener);
        }
    }
}

