/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.map;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.observable.map.ObservableMap;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.MapChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.RealmTester;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ObservableMapTest {
    ObservableMapStub<Object, Object> map;

    @Before
    public void setUp() throws Exception {
        RealmTester.setDefault((Realm)new CurrentRealm(true));
        this.map = new ObservableMapStub(new HashMap());
    }

    @After
    public void tearDown() throws Exception {
        RealmTester.setDefault(null);
    }

    @Test
    public void testDisposeMapChangeListeners() throws Exception {
        MapChangeEventTracker listener = MapChangeEventTracker.observe(this.map);
        Assert.assertEquals((long)0L, (long)listener.count);
        this.map.fireMapChange(null);
        Assert.assertEquals((long)1L, (long)listener.count);
        this.map.dispose();
        try {
            this.map.fireMapChange(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals((String)"listener should not have been notified", (long)1L, (long)listener.count);
    }

    @Test
    public void testIsStaleRealmChecks() throws Exception {
        RealmTester.exerciseCurrent(() -> {
            boolean bl = this.map.isStale();
        });
    }

    @Test
    public void testSetStaleRealmChecks() throws Exception {
        RealmTester.exerciseCurrent(() -> this.map.setStale(true));
    }

    @Test
    public void testFireMapChangeRealmChecks() throws Exception {
        RealmTester.exerciseCurrent(() -> this.map.fireMapChange(null));
    }

    @Test
    public void testEquals() {
        Assert.assertTrue((boolean)this.map.equals(Collections.emptyMap()));
    }

    static class ObservableMapStub<K, V>
    extends ObservableMap<K, V> {
        public ObservableMapStub(Map<K, V> wrappedMap) {
            super(wrappedMap);
        }

        protected void fireMapChange(MapDiff<K, V> diff) {
            super.fireMapChange(diff);
        }
    }
}

