/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.map;

import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.observable.map.WritableMap;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.MapChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.RealmTester;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WritableMapTest {
    @Before
    public void setUp() throws Exception {
        RealmTester.setDefault((Realm)new CurrentRealm(true));
    }

    @After
    public void tearDown() throws Exception {
        RealmTester.setDefault(null);
    }

    @Test
    public void testPutRealmChecks() throws Exception {
        RealmTester.exerciseCurrent(() -> {
            WritableMap map = new WritableMap();
            map.put((Object)"", (Object)"");
        });
    }

    @Test
    public void testRemoveRealmChecks() throws Exception {
        RealmTester.exerciseCurrent(() -> {
            WritableMap map = new WritableMap();
            CurrentRealm realm = (CurrentRealm)Realm.getDefault();
            boolean current = realm.isCurrent();
            realm.setCurrent(true);
            map.put((Object)"", (Object)"");
            realm.setCurrent(current);
            map.remove((Object)"");
        });
    }

    @Test
    public void testClearRealmChecks() throws Exception {
        RealmTester.exerciseCurrent(() -> {
            WritableMap map = new WritableMap();
            map.clear();
        });
    }

    @Test
    public void testPutAllRealmChecks() throws Exception {
        RealmTester.exerciseCurrent(() -> {
            WritableMap map = new WritableMap();
            map.putAll(Collections.emptyMap());
        });
    }

    @Test
    public void testPutWithExistingKeyMapChangeEvent() throws Exception {
        WritableMap map = new WritableMap();
        String key = "key";
        String value = "value";
        map.put((Object)key, (Object)value);
        MapChangeEventTracker listener = new MapChangeEventTracker();
        map.addMapChangeListener((IMapChangeListener)listener);
        Assert.assertEquals((long)0L, (long)listener.count);
        String newValue = "new value";
        map.put((Object)key, (Object)newValue);
        Assert.assertEquals((long)1L, (long)listener.count);
        MapChangeEvent event = listener.event;
        Set changedKeys = event.diff.getChangedKeys();
        Assert.assertEquals((long)1L, (long)changedKeys.size());
        Assert.assertTrue((boolean)changedKeys.contains(key));
        Assert.assertEquals((Object)value, (Object)event.diff.getOldValue((Object)key));
        Assert.assertEquals((Object)newValue, (Object)event.diff.getNewValue((Object)key));
    }

    @Test
    public void testPutSameValue_NoMapChangeEvent() {
        WritableMap map = new WritableMap();
        Object key = new Object();
        String value = "value";
        map.put(key, (Object)value);
        MapChangeEventTracker tracker = MapChangeEventTracker.observe((IObservableMap)map);
        Assert.assertEquals((long)0L, (long)tracker.count);
        String equalValue = new String("value");
        map.put(key, (Object)equalValue);
        Assert.assertEquals((long)0L, (long)tracker.count);
    }

    @Test
    public void testPutNullKey_SingleAdditionChangeEvent() {
        WritableMap map = new WritableMap();
        MapChangeEventTracker tracker = MapChangeEventTracker.observe((IObservableMap)map);
        Assert.assertEquals((long)0L, (long)tracker.count);
        Object key = null;
        Object value = new Object();
        map.put(key, value);
        Assert.assertEquals((long)1L, (long)tracker.count);
        MapDiff diff = tracker.event.diff;
        Assert.assertEquals(Collections.singleton(key), (Object)diff.getAddedKeys());
        Assert.assertEquals(Collections.emptySet(), (Object)diff.getChangedKeys());
        Assert.assertEquals(Collections.emptySet(), (Object)diff.getRemovedKeys());
        Assert.assertEquals((Object)value, (Object)diff.getNewValue(key));
    }

    @Test
    public void testRemoveNullKey_SingleRemovalChangeEvent() {
        WritableMap map = new WritableMap();
        Object key = null;
        Object value = new Object();
        map.put(key, value);
        MapChangeEventTracker tracker = MapChangeEventTracker.observe((IObservableMap)map);
        map.remove(key);
        Assert.assertEquals((long)1L, (long)tracker.count);
        MapDiff diff = tracker.event.diff;
        Assert.assertEquals(Collections.emptySet(), (Object)diff.getAddedKeys());
        Assert.assertEquals(Collections.emptySet(), (Object)diff.getChangedKeys());
        Assert.assertEquals(Collections.singleton(key), (Object)diff.getRemovedKeys());
        Assert.assertEquals((Object)value, (Object)diff.getOldValue(key));
    }

    @Test
    public void testPutNullValue_SingleAdditionChangeEvent() {
        WritableMap map = new WritableMap();
        MapChangeEventTracker tracker = MapChangeEventTracker.observe((IObservableMap)map);
        Assert.assertEquals((long)0L, (long)tracker.count);
        Object key = new Object();
        Object value = null;
        map.put(key, value);
        Assert.assertEquals((long)1L, (long)tracker.count);
        MapDiff diff = tracker.event.diff;
        Assert.assertEquals(Collections.singleton(key), (Object)diff.getAddedKeys());
        Assert.assertEquals((Object)Collections.EMPTY_SET, (Object)diff.getChangedKeys());
        Assert.assertEquals((Object)Collections.EMPTY_SET, (Object)diff.getRemovedKeys());
        Assert.assertEquals(value, (Object)diff.getNewValue(key));
    }

    @Test
    public void testPutNullOverNonNullValue_SingleChangeEvent() {
        WritableMap map = new WritableMap();
        Object key = new Object();
        Object oldValue = new Object();
        map.put(key, oldValue);
        MapChangeEventTracker tracker = MapChangeEventTracker.observe((IObservableMap)map);
        Object newValue = null;
        map.put(key, newValue);
        Assert.assertEquals((long)1L, (long)tracker.count);
        MapDiff diff = tracker.event.diff;
        Assert.assertEquals(Collections.emptySet(), (Object)diff.getAddedKeys());
        Assert.assertEquals(Collections.singleton(key), (Object)diff.getChangedKeys());
        Assert.assertEquals(Collections.emptySet(), (Object)diff.getRemovedKeys());
        Assert.assertEquals((Object)oldValue, (Object)diff.getOldValue(key));
        Assert.assertEquals(newValue, (Object)diff.getNewValue(key));
    }

    @Test
    public void testPutNonNullOverNullValue_SingleChangeEvent() {
        WritableMap map = new WritableMap();
        Object key = new Object();
        Object oldValue = null;
        map.put(key, oldValue);
        MapChangeEventTracker tracker = MapChangeEventTracker.observe((IObservableMap)map);
        Object newValue = new Object();
        map.put(key, newValue);
        Assert.assertEquals((long)1L, (long)tracker.count);
        MapDiff diff = tracker.event.diff;
        Assert.assertEquals(Collections.emptySet(), (Object)diff.getAddedKeys());
        Assert.assertEquals(Collections.singleton(key), (Object)diff.getChangedKeys());
        Assert.assertEquals(Collections.emptySet(), (Object)diff.getRemovedKeys());
        Assert.assertEquals(oldValue, (Object)diff.getOldValue(key));
        Assert.assertEquals((Object)newValue, (Object)diff.getNewValue(key));
    }

    @Test
    public void testRemoveNullValue_SingleRemovalChangeEvent() {
        WritableMap map = new WritableMap();
        Object key = new Object();
        Object value = null;
        map.put(key, value);
        MapChangeEventTracker tracker = MapChangeEventTracker.observe((IObservableMap)map);
        map.remove(key);
        Assert.assertEquals((long)1L, (long)tracker.count);
        MapDiff diff = tracker.event.diff;
        Assert.assertEquals(Collections.emptySet(), (Object)diff.getAddedKeys());
        Assert.assertEquals(Collections.emptySet(), (Object)diff.getChangedKeys());
        Assert.assertEquals(Collections.singleton(key), (Object)diff.getRemovedKeys());
        Assert.assertEquals(value, (Object)diff.getOldValue(key));
    }

    @Test
    public void testPutAllNullValue_SingleAdditionChangeEvent() {
        WritableMap map = new WritableMap();
        MapChangeEventTracker tracker = MapChangeEventTracker.observe((IObservableMap)map);
        Object key = new Object();
        Object value = null;
        HashMap<Object, Object> other = new HashMap<Object, Object>();
        other.put(key, value);
        map.putAll(other);
        Assert.assertEquals((long)1L, (long)tracker.count);
        MapDiff diff = tracker.event.diff;
        Assert.assertEquals(Collections.singleton(key), (Object)diff.getAddedKeys());
        Assert.assertEquals(Collections.emptySet(), (Object)diff.getChangedKeys());
        Assert.assertEquals(Collections.emptySet(), (Object)diff.getRemovedKeys());
        Assert.assertEquals(value, (Object)diff.getNewValue(key));
    }

    @Test
    public void testPutAllNullValueToNonNullValue_SingleChangeEvent() {
        WritableMap map = new WritableMap();
        Object key = new Object();
        Object oldValue = null;
        map.put(key, oldValue);
        MapChangeEventTracker tracker = MapChangeEventTracker.observe((IObservableMap)map);
        Object newValue = new Object();
        HashMap<Object, Object> other = new HashMap<Object, Object>();
        other.put(key, newValue);
        map.putAll(other);
        Assert.assertEquals((long)1L, (long)tracker.count);
        MapDiff diff = tracker.event.diff;
        Assert.assertEquals(Collections.emptySet(), (Object)diff.getAddedKeys());
        Assert.assertEquals(Collections.singleton(key), (Object)diff.getChangedKeys());
        Assert.assertEquals(Collections.emptySet(), (Object)diff.getRemovedKeys());
        Assert.assertEquals(oldValue, (Object)diff.getOldValue(key));
        Assert.assertEquals((Object)newValue, (Object)diff.getNewValue(key));
    }

    @Test
    public void testPutAllNonNullValueToNullValue_SingleChangeEvent() {
        WritableMap map = new WritableMap();
        Object key = new Object();
        Object oldValue = new Object();
        map.put(key, oldValue);
        MapChangeEventTracker tracker = MapChangeEventTracker.observe((IObservableMap)map);
        Object newValue = null;
        HashMap<Object, Object> other = new HashMap<Object, Object>();
        other.put(key, newValue);
        map.putAll(other);
        Assert.assertEquals((long)1L, (long)tracker.count);
        MapDiff diff = tracker.event.diff;
        Assert.assertEquals(Collections.emptySet(), (Object)diff.getAddedKeys());
        Assert.assertEquals(Collections.singleton(key), (Object)diff.getChangedKeys());
        Assert.assertEquals(Collections.emptySet(), (Object)diff.getRemovedKeys());
        Assert.assertEquals((Object)oldValue, (Object)diff.getOldValue(key));
        Assert.assertEquals(newValue, (Object)diff.getNewValue(key));
    }
}

