/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.set;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.AbstractObservableSet;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.jface.databinding.conformance.ObservableCollectionContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.TestCollection;

public class AbstractObservableSetTest {
    public static void addConformanceTest(TestCollection suite) {
        suite.addTest(ObservableCollectionContractTest.class, (Object)new Delegate());
    }

    private static class AbstractObservableSetStub<E>
    extends AbstractObservableSet<E> {
        private final Object type;
        private final HashSet<E> set = new HashSet();

        private AbstractObservableSetStub(Realm realm, Object type) {
            super(realm);
            this.type = type;
        }

        protected Set<E> getWrappedSet() {
            return this.set;
        }

        public Object getElementType() {
            return this.type;
        }

        protected void fireSetChange(SetDiff<E> diff) {
            super.fireSetChange(diff);
        }
    }

    private static class Delegate
    extends AbstractObservableCollectionContractDelegate<String> {
        private Delegate() {
        }

        public void change(IObservable observable) {
            ((AbstractObservableSetStub)observable).fireSetChange(Diffs.createSetDiff(new HashSet(), new HashSet()));
        }

        public String createElement(IObservableCollection<String> collection) {
            return Integer.toString(collection.size());
        }

        public Object getElementType(IObservableCollection<String> collection) {
            return String.class;
        }

        public IObservableCollection<String> createObservableCollection(Realm realm, int elementCount) {
            AbstractObservableSetStub set = new AbstractObservableSetStub(realm, String.class);
            int i = 0;
            while (i < elementCount) {
                set.getWrappedSet().add(Integer.toString(i));
                ++i;
            }
            return set;
        }
    }
}

