/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.set;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.AbstractObservable;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.ComputedSet;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.jface.databinding.conformance.ObservableCollectionContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.SetChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.TestCollection;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ComputedSetTest
extends AbstractDefaultRealmTestCase {
    ComputedSetStub set;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.set = new ComputedSetStub();
        this.set.size();
    }

    @Test
    public void testDependency_Staleness() {
        Assert.assertFalse((boolean)this.set.isStale());
        this.set.dependency.fireStale();
        Assert.assertTrue((boolean)this.set.isStale());
    }

    @Test
    public void testDependency_FiresSetChange() {
        Assert.assertEquals(this.set.nextComputation, (Object)((Object)this.set));
        Object element = new Object();
        this.set.nextComputation.add(element);
        this.set.dependency.fireChange();
        Assert.assertEquals(Collections.singleton(element), (Object)((Object)this.set));
    }

    @Test
    public void testDependency_NoStaleEventIfAlreadyDirty() {
        this.set.dependency.fireChange();
        this.set.addStaleListener(staleEvent -> Assert.fail((String)"Should not fire stale when set is already dirty"));
        this.set.dependency.fireStale();
    }

    @Test
    public void testDependency_SetChangeEventFiresOnlyWhenNotDirty() {
        SetChangeEventTracker tracker = SetChangeEventTracker.observe((IObservableSet)this.set);
        this.set.dependency.fireChange();
        Assert.assertEquals((String)"ComputedSet should fire set change event when its dependency changes", (long)1L, (long)tracker.count);
        this.set.dependency.fireChange();
        Assert.assertEquals((String)"ComputedSet should not fire set change events when dirty", (long)1L, (long)tracker.count);
        this.set.size();
        this.set.dependency.fireChange();
        Assert.assertEquals((String)"ComputedSet should fire set change event when its dependency changes", (long)2L, (long)tracker.count);
    }

    @Test
    public void testCreate() throws Exception {
        WritableSet writeSet = new WritableSet();
        writeSet.add((Object)44);
        IObservableSet compSet = ComputedSet.create(() -> new HashSet(writeSet));
        Assert.assertEquals((Object)writeSet, (Object)compSet);
        writeSet.add((Object)55);
        Assert.assertEquals((Object)writeSet, (Object)compSet);
    }

    public static void addConformanceTest(TestCollection suite) {
        suite.addTest(ObservableCollectionContractTest.class, (Object)new Delegate());
    }

    static class ComputedSetStub
    extends ComputedSet<Object> {
        Set<Object> nextComputation = new HashSet<Object>();
        ObservableStub dependency;

        ComputedSetStub() {
            this(Realm.getDefault());
        }

        ComputedSetStub(Realm realm) {
            super(realm);
            this.dependency = new ObservableStub(realm);
        }

        protected Set<Object> calculate() {
            ObservableTracker.getterCalled((IObservable)this.dependency);
            return new HashSet<Object>(this.nextComputation);
        }
    }

    static class Delegate
    extends AbstractObservableCollectionContractDelegate<Object> {
        Delegate() {
        }

        public IObservableCollection<Object> createObservableCollection(Realm realm, int elementCount) {
            ComputedSetStub set = new ComputedSetStub(realm);
            int i = 0;
            while (i < elementCount) {
                set.nextComputation.add(this.createElement((IObservableCollection<Object>)set));
                ++i;
            }
            set.size();
            return set;
        }

        public void change(IObservable observable) {
            ComputedSetStub set = (ComputedSetStub)observable;
            set.nextComputation.add(new Object());
            set.dependency.fireChange();
        }

        public Object createElement(IObservableCollection<Object> collection) {
            return new Object();
        }

        public void setStale(IObservable observable, boolean stale) {
            if (stale) {
                ((ComputedSetStub)observable).dependency.fireStale();
            } else {
                ComputedSetStub computedSet = (ComputedSetStub)observable;
                computedSet.dependency.stale = false;
                computedSet.dependency.fireChange();
            }
        }
    }

    static class ObservableStub
    extends AbstractObservable {
        boolean stale;

        public ObservableStub(Realm realm) {
            super(realm);
        }

        public boolean isStale() {
            return this.stale;
        }

        protected void fireStale() {
            this.stale = true;
            super.fireStale();
        }

        protected void fireChange() {
            super.fireChange();
        }
    }
}

