/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.set;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.ObservableSet;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.jface.databinding.conformance.ObservableCollectionContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.TestCollection;

public class ObservableSetTest {
    public static void addConformanceTest(TestCollection suite) {
        suite.addTest(ObservableCollectionContractTest.class, (Object)new Delegate());
    }

    private static class Delegate
    extends AbstractObservableCollectionContractDelegate<String> {
        private Delegate() {
        }

        public void change(IObservable observable) {
            ((ObservableSetStub)observable).fireSetChange((SetDiff<String>)Diffs.createSetDiff(new HashSet(), new HashSet()));
        }

        public String createElement(IObservableCollection<String> collection) {
            return Integer.toString(collection.size());
        }

        public Object getElementType(IObservableCollection<String> collection) {
            return String.class;
        }

        public IObservableCollection<String> createObservableCollection(Realm realm, int elementCount) {
            ObservableSetStub set = new ObservableSetStub(realm, new HashSet<String>(), String.class);
            int i = 0;
            while (i < elementCount) {
                set.add(Integer.toString(i));
                ++i;
            }
            return set;
        }
    }

    private static class ObservableSetStub
    extends ObservableSet<String> {
        protected ObservableSetStub(Realm realm, Set<String> wrappedSet, Object elementType) {
            super(realm, wrappedSet, elementType);
        }

        public void fireSetChange(SetDiff<String> diff) {
            super.fireSetChange(diff);
        }
    }
}

