/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.set;

import java.util.Collections;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.jface.databinding.conformance.MutableObservableSetContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.TestCollection;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Test;

public class WritableSetTest
extends AbstractDefaultRealmTestCase {
    @Test
    public void testWithElementType() throws Exception {
        Class<String> elementType = String.class;
        WritableSet set = WritableSet.withElementType(elementType);
        Assert.assertNotNull((Object)set);
        Assert.assertEquals((Object)Realm.getDefault(), (Object)set.getRealm());
        Assert.assertEquals(elementType, (Object)set.getElementType());
    }

    public static void addConformanceTest(TestCollection suite) {
        suite.addTest(MutableObservableSetContractTest.class, (Object)new Delegate());
    }

    private static class Delegate
    extends AbstractObservableCollectionContractDelegate<Object> {
        private Delegate() {
        }

        public void change(IObservable observable) {
            IObservableSet set = (IObservableSet)observable;
            set.add(this.createElement((IObservableCollection<Object>)set));
        }

        public Object createElement(IObservableCollection<Object> collection) {
            return new Object();
        }

        public Object getElementType(IObservableCollection<Object> collection) {
            return String.class;
        }

        public IObservableCollection<Object> createObservableCollection(Realm realm, int elementCount) {
            WritableSet set = new WritableSet(realm, Collections.emptySet(), String.class);
            int i = 0;
            while (i < elementCount) {
                set.add(this.createElement((IObservableCollection<Object>)set));
                ++i;
            }
            return set;
        }
    }
}

