/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.value;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.RealmTester;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AbstractObservableValueTest {
    @Before
    public void setUp() throws Exception {
        RealmTester.setDefault((Realm)new CurrentRealm(true));
    }

    @After
    public void tearDown() throws Exception {
        RealmTester.setDefault(null);
    }

    @Test
    public void testSetValueRealmChecks() throws Exception {
        RealmTester.exerciseCurrent(() -> {
            ObservableValueStub observable = new ObservableValueStub();
            try {
                observable.setValue(null);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        });
    }

    @Test
    public void testSetValueInvokesDoSetValue() throws Exception {
        CurrentRealm realm = new CurrentRealm(true);
        class ValueStub
        extends ObservableValueStub {
            int doSetValue;

            ValueStub(Realm realm) {
                super(realm);
            }

            protected void doSetValue(Object value) {
                ++this.doSetValue;
            }
        }
        ValueStub stub = new ValueStub((Realm)realm);
        Assert.assertEquals((long)0L, (long)stub.doSetValue);
        stub.setValue(new Object());
        Assert.assertEquals((String)"doSetValue should have been invoked", (long)1L, (long)stub.doSetValue);
    }

    @Test
    public void testFireValueChangeRealmChecks() throws Exception {
        RealmTester.exerciseCurrent(() -> {
            ObservableValueStub observable = new ObservableValueStub();
            observable.fireValueChange(null);
        });
    }

    private static class ObservableValueStub
    extends AbstractObservableValue<Object> {
        ObservableValueStub() {
            super(Realm.getDefault());
        }

        private ObservableValueStub(Realm realm) {
            super(realm);
        }

        protected Object doGetValue() {
            return null;
        }

        public Object getValueType() {
            return null;
        }

        protected void fireValueChange(ValueDiff<Object> diff) {
            super.fireValueChange(diff);
        }
    }
}

