/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.value;

import java.util.ArrayList;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Test;

public class ComputedValueTest
extends AbstractDefaultRealmTestCase {
    @Test
    public void testValueType() throws Exception {
        ComputedValue cv = new ComputedValue<Integer>(Integer.TYPE){

            protected Integer calculate() {
                return 42;
            }
        };
        Assert.assertEquals((String)"value type should be the type that was set", Integer.TYPE, (Object)cv.getValueType());
        cv = new ComputedValue<Integer>(){

            protected Integer calculate() {
                return null;
            }
        };
        Assert.assertNull((Object)cv.getValueType());
    }

    @Test
    public void test_getValue() throws Exception {
        ComputedValue<Integer> cv = new ComputedValue<Integer>(){

            protected Integer calculate() {
                return 42;
            }
        };
        Assert.assertEquals((String)"Calculated value should be 42", (Object)42, (Object)cv.getValue());
    }

    @Test
    public void testDependencyValueChange() throws Exception {
        final WritableValue value = new WritableValue((Object)42, Integer.TYPE);
        ComputedValue<Integer> cv = new ComputedValue<Integer>(){

            protected Integer calculate() {
                return (Integer)value.getValue();
            }
        };
        Assert.assertEquals((String)"calculated value should have been that of the writable value", (Object)value.getValue(), (Object)cv.getValue());
        value.setValue((Object)44);
        Assert.assertEquals((String)"calculated value should have been that of the writable value", (Object)value.getValue(), (Object)cv.getValue());
    }

    @Test
    public void testCreate() throws Exception {
        WritableValue value = new WritableValue((Object)42, null);
        IObservableValue cv = ComputedValue.create(() -> ((WritableValue)value).getValue());
        Assert.assertEquals((Object)value.getValue(), (Object)cv.getValue());
        value.setValue((Object)44);
        Assert.assertEquals((Object)value.getValue(), (Object)cv.getValue());
    }

    @Test
    public void testHookAndUnhookDependantObservables() throws Exception {
        final ArrayList<WritableValueExt<Integer>> values = new ArrayList<WritableValueExt<Integer>>();
        ComputedValue<Integer> cv = new ComputedValue<Integer>(){

            protected Integer calculate() {
                int sum = 0;
                for (WritableValue value : values) {
                    sum += ((Integer)value.getValue()).intValue();
                }
                return sum;
            }
        };
        WritableValueExt<Integer> value1 = new WritableValueExt<Integer>(Integer.TYPE, 1);
        WritableValueExt<Integer> value2 = new WritableValueExt<Integer>(Integer.TYPE, 1);
        values.add(value1);
        values.add(value2);
        Assert.assertFalse((boolean)value1.hasListeners());
        Assert.assertFalse((boolean)value2.hasListeners());
        cv.getValue();
        Assert.assertTrue((boolean)value1.hasListeners());
        Assert.assertTrue((boolean)value2.hasListeners());
        value2.setValue(2);
        values.remove(value2);
        cv.getValue();
        Assert.assertEquals((Object)1, (Object)cv.getValue());
        Assert.assertTrue((boolean)value1.hasListeners());
        Assert.assertFalse((String)"because value2 is not a part of the calculation the listeners should have been removed", (boolean)value2.hasListeners());
    }

    @Test
    public void testSetValueUnsupportedOperationException() throws Exception {
        ComputedValue<Object> cv = new ComputedValue<Object>(){

            protected Object calculate() {
                return null;
            }
        };
        Assert.assertThrows(UnsupportedOperationException.class, () -> ComputedValueTest.lambda$1((ComputedValue)cv));
    }

    private static /* synthetic */ void lambda$1(ComputedValue computedValue) throws Throwable {
        computedValue.setValue(new Object());
    }

    private static class WritableValueExt<E>
    extends WritableValue<E> {
        public WritableValueExt(Object valueType, E initialValue) {
            super(initialValue, valueType);
        }

        public boolean hasListeners() {
            return super.hasListeners();
        }
    }
}

