/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.value;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.DuplexingObservableValue;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DuplexingObservableValueTest
extends AbstractDefaultRealmTestCase {
    private IObservableList<String> list;
    private DuplexingObservableValue<String> observable;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.list = new WritableList(new ArrayList(), String.class);
    }

    @Test
    public void testValueType_InheritFromTargetList() throws Exception {
        this.observable = new DuplexingObservableValue<String>(this.list){

            protected String coalesceElements(Collection<String> elements) {
                return null;
            }
        };
        Assert.assertEquals((String)"value type should be the element type of the target list", String.class, (Object)this.observable.getValueType());
    }

    @Test
    public void testValueType_ProvidedInConstructor() throws Exception {
        this.observable = new DuplexingObservableValue<String>(this.list, Object.class){

            protected String coalesceElements(Collection<String> elements) {
                return null;
            }
        };
        Assert.assertEquals((String)"value type should be the type passed to constructor", Object.class, (Object)this.observable.getValueType());
    }

    @Test
    public void test_getValue() throws Exception {
        this.observable = DuplexingObservableValue.withDefaults(this.list, null, (Object)"<Multiple Values>");
        Assert.assertNull((Object)this.observable.getValue());
        this.list.add((Object)"42");
        Assert.assertEquals((String)"Value should be \"42\"", (Object)"42", (Object)this.observable.getValue());
        this.list.add((Object)"42");
        Assert.assertEquals((String)"Value should be \"42\"", (Object)"42", (Object)this.observable.getValue());
        this.list.add((Object)"watermelon");
        Assert.assertEquals((Object)"<Multiple Values>", (Object)this.observable.getValue());
        this.list.remove(2);
        Assert.assertEquals((String)"Value should be \"42\"", (Object)"42", (Object)this.observable.getValue());
        this.list.clear();
        Assert.assertNull((Object)this.observable.getValue());
    }
}

