/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.value;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.LocalDateTimeObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LocalDateTimeObservableValueTest
extends AbstractDefaultRealmTestCase {
    private IObservableValue<LocalDate> date;
    private IObservableValue<LocalTime> time;
    private IObservableValue<LocalDateTime> dateAndTime;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.date = WritableValue.withValueType(LocalDate.class);
        this.time = WritableValue.withValueType(LocalTime.class);
        this.dateAndTime = new LocalDateTimeObservableValue(this.date, this.time);
    }

    @Test
    public void testGetValue_NullDateNullResult() {
        this.date.setValue(null);
        this.time.setValue((Object)LocalTime.of(12, 27, 17));
        Assert.assertNull((Object)this.dateAndTime.getValue());
    }

    @Test
    public void testGetValue_NullTimeClearsTime() {
        this.date.setValue((Object)LocalDate.of(2009, 3, 3));
        this.time.setValue(null);
        Assert.assertEquals((Object)LocalDateTime.of(2009, 3, 3, 0, 0, 0), (Object)this.dateAndTime.getValue());
    }

    @Test
    public void testGetValue() {
        this.date.setValue((Object)LocalDate.of(2009, 3, 3));
        this.time.setValue((Object)LocalTime.of(23, 59, 59));
        Assert.assertEquals((Object)LocalDateTime.of(2009, 3, 3, 23, 59, 59), (Object)this.dateAndTime.getValue());
    }

    @Test
    public void testSetValue() {
        this.date.setValue((Object)LocalDate.of(2009, 3, 3));
        this.time.setValue((Object)LocalTime.of(12, 32, 55));
        this.dateAndTime.setValue((Object)LocalDateTime.of(2010, 1, 1, 2, 3, 5));
        Assert.assertEquals((Object)LocalDate.of(2010, 1, 1), (Object)this.date.getValue());
        Assert.assertEquals((Object)LocalTime.of(2, 3, 5), (Object)this.time.getValue());
    }

    @Test
    public void testSetValue_NullNullsDateClearsTime() {
        this.date.setValue((Object)LocalDate.of(2009, 3, 3));
        this.time.setValue((Object)LocalTime.of(12, 25, 34));
        this.dateAndTime.setValue(null);
        Assert.assertEquals(null, (Object)this.date.getValue());
        Assert.assertEquals((Object)LocalTime.of(0, 0, 0), (Object)this.time.getValue());
    }

    @Test
    public void testSetValue_PreserveTimeOfDateAndDateOfTime() {
        this.date.setValue((Object)LocalDate.of(2009, 3, 3));
        this.time.setValue((Object)LocalTime.of(12, 32, 55));
        this.dateAndTime.setValue((Object)LocalDateTime.of(2010, 1, 1, 2, 3, 5));
        Assert.assertEquals((Object)LocalDate.of(2010, 1, 1), (Object)this.date.getValue());
        Assert.assertEquals((Object)LocalTime.of(2, 3, 5), (Object)this.time.getValue());
    }
}

