/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.observable.value;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.databinding.conformance.MutableObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.util.TestCollection;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.eclipse.swt.widgets.Display;
import org.junit.Assert;
import org.junit.Test;

public class WritableValueTest
extends AbstractDefaultRealmTestCase {
    @Test
    public void testConstructor() throws Exception {
        WritableValue value = new WritableValue(DisplayRealm.getRealm((Display)Display.getDefault()));
        Assert.assertNull((Object)value.getValue());
        Assert.assertNull((Object)value.getValueType());
    }

    @Test
    public void testWithValueType() throws Exception {
        Class<String> elementType = String.class;
        WritableValue value = WritableValue.withValueType(elementType);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)Realm.getDefault(), (Object)value.getRealm());
        Assert.assertEquals(elementType, (Object)value.getValueType());
    }

    public static void addConformanceTest(TestCollection suite) {
        suite.addTest(MutableObservableValueContractTest.class, (Object)new Delegate());
    }

    static class Delegate
    extends AbstractObservableValueContractDelegate {
        Delegate() {
        }

        public IObservableValue<?> createObservableValue(Realm realm) {
            return new WritableValue(realm, (Object)"", String.class);
        }

        public void change(IObservable observable) {
            IObservableValue observableValue = (IObservableValue)observable;
            observableValue.setValue(this.createValue(observableValue));
        }

        public Object getValueType(IObservableValue<?> observable) {
            return String.class;
        }

        public String createValue(IObservableValue<?> observable) {
            return String.valueOf(observable.getValue()) + "a";
        }
    }
}

