/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.eclipse.core.databinding.util.ILogger;
import org.eclipse.core.databinding.util.Policy;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.junit.Assert;
import org.junit.Test;

public class PolicyTest {
    @Test
    public void testConstructor() {
        new Policy();
    }

    @Test
    public void testDummyLog() {
        ILogger oldLog = Policy.getLog();
        PrintStream oldErr = System.err;
        try {
            Policy.setLog(null);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(os);
            System.setErr(ps);
            Status status = new Status(8, "somePluginId", "someMessage", (Throwable)new RuntimeException());
            Policy.getLog().log((IStatus)status);
            ps.flush();
            String message = new String(os.toByteArray());
            System.out.println("testDummyLog message: " + message);
            Assert.assertTrue((String)"expecting severity", (boolean)message.contains("CANCEL"));
            Assert.assertTrue((String)"expecting plugin id", (boolean)message.contains("somePluginId"));
            Assert.assertTrue((String)"expecting message", (boolean)message.contains("someMessage"));
            Assert.assertTrue((String)"expecting RuntimeException", (boolean)message.contains("RuntimeException"));
        }
        finally {
            Policy.setLog((ILogger)oldLog);
            System.setErr(oldErr);
        }
    }

    @Test
    public void testCustomLog() {
        ILogger oldLog = Policy.getLog();
        try {
            IStatus[] statusHolder = new IStatus[1];
            Policy.setLog(status -> {
                IStatus iStatus = status;
            });
            Status status2 = new Status(8, "somePluginId", "someMessage", (Throwable)new RuntimeException());
            Policy.getLog().log((IStatus)status2);
            Assert.assertEquals((Object)status2, (Object)statusHolder[0]);
        }
        finally {
            Policy.setLog((ILogger)oldLog);
        }
    }
}

