/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.databinding.validation;

import java.util.ArrayList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.AbstractObservable;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.internal.databinding.validation.ValidatedObservableValue;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.StaleEventTracker;
import org.eclipse.jface.databinding.conformance.util.ValueChangeEventTracker;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiValidatorTest
extends AbstractDefaultRealmTestCase {
    private DependencyObservableValue<Object> dependency;
    private MultiValidator validator;
    private IObservableValue<IStatus> validationStatus;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.dependency = new DependencyObservableValue<Object>(null, IStatus.class);
        this.validator = new MultiValidator(){

            protected IStatus validate() {
                return (IStatus)MultiValidatorTest.this.dependency.getValue();
            }
        };
        this.validationStatus = this.validator.getValidationStatus();
    }

    @Test
    public void testConstructor_NullArgument() {
        Assert.assertThrows(AssertionFailedException.class, () -> {
            MultiValidator multiValidator = new MultiValidator(null){

                protected IStatus validate() {
                    return null;
                }
            };
        });
    }

    @Test
    public void testGetValidationStatus_NullResultYieldsOKStatus() {
        IStatus status = (IStatus)this.validationStatus.getValue();
        Assert.assertTrue((boolean)status.isOK());
    }

    @Test
    public void testGetValidationStatus_ExceptionThrownYieldsErrorStatus() {
        final RuntimeException e = new RuntimeException("message");
        this.validator = new MultiValidator(){

            protected IStatus validate() {
                throw e;
            }
        };
        Assert.assertEquals((Object)ValidationStatus.error((String)"message", (Throwable)e), (Object)this.validator.getValidationStatus().getValue());
    }

    @Test
    public void testGetValidationStatus_TracksWithDependency() {
        IStatus newStatus = ValidationStatus.error((String)"error");
        this.dependency.setValue(newStatus);
        Assert.assertEquals((Object)newStatus, (Object)this.validationStatus.getValue());
    }

    @Test
    public void testInit_AddsValidationProducer() {
        DataBindingContext dbc = new DataBindingContext();
        dbc.addValidationStatusProvider((ValidationStatusProvider)this.validator);
        Assert.assertTrue((boolean)dbc.getValidationStatusProviders().contains((Object)this.validator));
    }

    @Test
    public void testObserveValidatedValue_NullArgument() {
        Assert.assertThrows(AssertionFailedException.class, () -> {
            IObservableValue iObservableValue = this.validator.observeValidatedValue(null);
        });
    }

    @Test
    public void testObserveValidatedValue_WrongRealm() {
        CurrentRealm otherRealm = new CurrentRealm(true);
        Assert.assertThrows(AssertionFailedException.class, () -> this.lambda$2((Realm)otherRealm));
    }

    @Test
    public void testObserveValidatedValue_ReturnValue() {
        WritableValue target = new WritableValue();
        ValidatedObservableValue validated = (ValidatedObservableValue)this.validator.observeValidatedValue((IObservableValue)target);
        target.setValue(new Object());
        Assert.assertEquals((Object)target.getValue(), (Object)validated.getValue());
        this.dependency.setValue(ValidationStatus.error((String)"error"));
        Assert.assertFalse((boolean)validated.isStale());
        target.setValue(new Object());
        Assert.assertTrue((boolean)validated.isStale());
        Assert.assertFalse((boolean)target.getValue().equals(validated.getValue()));
        this.dependency.setValue(ValidationStatus.info((String)"info"));
        Assert.assertEquals((Object)target.getValue(), (Object)validated.getValue());
        Assert.assertFalse((boolean)validated.isStale());
    }

    @Test
    public void testBug237884_DisposeCausesNPE() {
        MultiValidator validator = new MultiValidator(){

            protected IStatus validate() {
                return ValidationStatus.ok();
            }
        };
        validator.dispose();
    }

    @Test
    public void testBug237884_MultipleDispose() {
        this.validator.dispose();
        this.validator.dispose();
    }

    @Test
    public void testBug237884_Comment3_ValidationStatusAsDependencyCausesStackOverflow() {
        this.dependency = new DependencyObservableValue<Object>(new Object(), Object.class);
        this.validator = new MultiValidator(){
            private int counter;

            protected IStatus validate() {
                ObservableTracker.getterCalled(MultiValidatorTest.this.dependency);
                return ValidationStatus.info((String)("info " + this.counter++));
            }
        };
        this.validationStatus = this.validator.getValidationStatus();
        this.validationStatus.addChangeListener(event -> ObservableTracker.getterCalled(this.validationStatus));
        this.dependency.setValue(new Object());
        try {
            this.dependency.setValue(new Object());
        }
        catch (StackOverflowError e) {
            Assert.fail((String)"Bug 237884: Accessing MultiValidator validation status from within listener causes infinite recursion");
        }
    }

    @Test
    public void testBug237884_ValidationStatusListenerCausesLoopingDependency() {
        this.validationStatus.addChangeListener(event -> ObservableTracker.getterCalled(this.validationStatus));
        Assert.assertFalse((boolean)this.validator.getTargets().contains(this.validationStatus));
        this.dependency.setValue(ValidationStatus.info((String)"info"));
        Assert.assertFalse((boolean)this.validator.getTargets().contains(this.validationStatus));
    }

    @Test
    public void testRevalidate() {
        IStatus[] status = new IStatus[]{ValidationStatus.ok()};
        class MyMultiValidator
        extends MultiValidator {
            private final /* synthetic */ IStatus[] val$status;

            MyMultiValidator(IStatus[] iStatusArray) {
                this.val$status = iStatusArray;
            }

            protected IStatus validate() {
                return this.val$status[0];
            }

            protected void callRevalidate() {
                this.revalidate();
            }
        }
        MyMultiValidator validator = new MyMultiValidator(status);
        Assert.assertSame((Object)status[0], (Object)validator.getValidationStatus().getValue());
        status[0] = ValidationStatus.error((String)"");
        Assert.assertNotSame((Object)status[0], (Object)validator.getValidationStatus().getValue());
        validator.callRevalidate();
        Assert.assertSame((Object)status[0], (Object)validator.getValidationStatus().getValue());
    }

    @Test
    public void testBug237884_ValidationStatusAccessDuringValidationCausesLoopingDependency() {
        this.validator = new MultiValidator(){

            protected IStatus validate() {
                ObservableTracker.getterCalled((IObservable)this.getValidationStatus());
                return (IStatus)MultiValidatorTest.this.dependency.getValue();
            }
        };
        this.dependency.setValue(ValidationStatus.info((String)"info"));
        Assert.assertFalse((boolean)this.validator.getTargets().contains(this.validationStatus));
    }

    @Test
    public void testBug240590_ValidationStatusSetWhileTrackingDependencies() {
        WritableValue noDependency = new WritableValue();
        this.validationStatus.addValueChangeListener(arg_0 -> MultiValidatorTest.lambda$5((IObservableValue)noDependency, arg_0));
        this.dependency.setValue(ValidationStatus.error((String)"new error"));
        Assert.assertFalse((boolean)this.validator.getTargets().contains((Object)noDependency));
    }

    @Test
    public void testValidationStaleness() {
        ValueChangeEventTracker validationChangeCounter = ValueChangeEventTracker.observe(this.validationStatus);
        StaleEventTracker validationStaleCounter = StaleEventTracker.observe(this.validationStatus);
        Assert.assertFalse((boolean)this.validationStatus.isStale());
        Assert.assertEquals((long)0L, (long)validationChangeCounter.count);
        Assert.assertEquals((long)0L, (long)validationStaleCounter.count);
        this.dependency.setStale(true);
        Assert.assertTrue((boolean)this.validationStatus.isStale());
        Assert.assertEquals((long)0L, (long)validationChangeCounter.count);
        Assert.assertEquals((long)1L, (long)validationStaleCounter.count);
        this.dependency.fireStale();
        Assert.assertTrue((boolean)this.validationStatus.isStale());
        Assert.assertEquals((long)0L, (long)validationChangeCounter.count);
        Assert.assertEquals((long)1L, (long)validationStaleCounter.count);
        this.dependency.setValue(ValidationStatus.error((String)"e1"));
        Assert.assertTrue((boolean)this.validationStatus.isStale());
        Assert.assertEquals((long)1L, (long)validationChangeCounter.count);
        Assert.assertEquals((long)1L, (long)validationStaleCounter.count);
        this.dependency.setStale(false);
        Assert.assertFalse((boolean)this.dependency.isStale());
        Assert.assertFalse((boolean)this.validationStatus.isStale());
        Assert.assertEquals((long)2L, (long)validationChangeCounter.count);
        Assert.assertEquals((long)1L, (long)validationStaleCounter.count);
    }

    @Test
    public void testStatusValueChangeWhileValidationStale() {
        this.dependency.setStale(true);
        Assert.assertTrue((boolean)this.validationStatus.isStale());
        this.dependency.setValue(ValidationStatus.error((String)"e1"));
        Assert.assertTrue((boolean)this.validationStatus.isStale());
        Assert.assertEquals((Object)this.dependency.getValue(), (Object)this.validationStatus.getValue());
        this.dependency.setValue(ValidationStatus.error((String)"e2"));
        Assert.assertTrue((boolean)this.validationStatus.isStale());
        Assert.assertEquals((Object)this.dependency.getValue(), (Object)this.validationStatus.getValue());
    }

    @Test
    public void testValidationStatusBecomesStaleThroughNewDependency() {
        final DependencyObservableValue<IStatus> nonStaleDependency = new DependencyObservableValue<IStatus>(ValidationStatus.ok(), IStatus.class);
        nonStaleDependency.setStale(false);
        final DependencyObservableValue<IStatus> staleDependency = new DependencyObservableValue<IStatus>(ValidationStatus.ok(), IStatus.class);
        staleDependency.setStale(true);
        this.validator = new MultiValidator(){

            protected IStatus validate() {
                if (nonStaleDependency.getValue() != null) {
                    return (IStatus)nonStaleDependency.getValue();
                }
                return (IStatus)staleDependency.getValue();
            }
        };
        this.validationStatus = this.validator.getValidationStatus();
        Assert.assertFalse((boolean)this.validationStatus.isStale());
        StaleEventTracker validationStaleCounter = StaleEventTracker.observe(this.validationStatus);
        Assert.assertEquals((long)0L, (long)validationStaleCounter.count);
        nonStaleDependency.setValue(null);
        Assert.assertTrue((boolean)this.validationStatus.isStale());
        Assert.assertEquals((long)1L, (long)validationStaleCounter.count);
    }

    @Test
    public void testBug251003_CompareDependenciesByIdentity() {
        DependencyObservable dependency1 = new DependencyObservable();
        DependencyObservable dependency2 = new DependencyObservable();
        Assert.assertEquals((Object)((Object)dependency1), (Object)((Object)dependency2));
        Assert.assertNotSame((Object)((Object)dependency1), (Object)((Object)dependency2));
        final ArrayList<DependencyObservable> dependencies = new ArrayList<DependencyObservable>();
        dependencies.add(dependency1);
        this.validator = new MultiValidator(){

            protected IStatus validate() {
                for (DependencyObservable dependencyObservable : dependencies) {
                    ObservableTracker.getterCalled((IObservable)dependencyObservable);
                }
                return null;
            }
        };
        this.validationStatus = this.validator.getValidationStatus();
        IObservableList targets = this.validator.getTargets();
        Assert.assertEquals((long)1L, (long)targets.size());
        Assert.assertSame((Object)((Object)dependency1), (Object)targets.get(0));
        dependencies.set(0, dependency2);
        dependency1.fireChange();
        Assert.assertEquals((long)1L, (long)targets.size());
        Assert.assertSame((Object)((Object)dependency2), (Object)targets.get(0));
    }

    @Test
    public void testBug251003_MissingDependencies() {
        final WritableList emptyListDependency = new WritableList();
        this.validator = new MultiValidator(){

            protected IStatus validate() {
                ObservableTracker.getterCalled((IObservable)emptyListDependency);
                return null;
            }
        };
        this.validator.getValidationStatus().getValue();
        Assert.assertTrue((boolean)this.validator.getTargets().contains((Object)emptyListDependency));
    }

    @Test
    public void testBug357568_MultiValidatorTargetAsDependency() {
        this.validator = new MultiValidator(){

            protected IStatus validate() {
                ObservableTracker.getterCalled(MultiValidatorTest.this.dependency);
                ObservableTracker.getterCalled((IObservable)new DependencyObservable());
                ObservableTracker.getterCalled((IObservable)MultiValidatorTest.this.validator.getTargets());
                return null;
            }
        };
        this.validator.getValidationStatus().getValue();
        this.dependency.setValue(ValidationStatus.info((String)"foo"));
    }

    @Test
    public void testBug357568_ValidationStatusAsDependency() {
        this.validator = new MultiValidator(){

            protected IStatus validate() {
                return (IStatus)MultiValidatorTest.this.validator.getValidationStatus().getValue();
            }
        };
        this.validator.getValidationStatus();
    }

    private /* synthetic */ void lambda$2(Realm realm) throws Throwable {
        IObservableValue iObservableValue = this.validator.observeValidatedValue((IObservableValue)new WritableValue(realm));
    }

    private static /* synthetic */ void lambda$5(IObservableValue iObservableValue, ValueChangeEvent event) {
        ObservableTracker.getterCalled((IObservable)iObservableValue);
    }

    private static class DependencyObservable
    extends AbstractObservable {
        public DependencyObservable() {
            super(Realm.getDefault());
        }

        public boolean isStale() {
            return false;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            return ((Object)((Object)this)).getClass() == obj.getClass();
        }

        public int hashCode() {
            return ((Object)((Object)this)).getClass().hashCode();
        }

        protected void fireChange() {
            super.fireChange();
        }
    }

    private static class DependencyObservableValue<T>
    extends WritableValue<T> {
        private boolean stale = false;

        public DependencyObservableValue(T initialValue, Object valueType) {
            super(initialValue, valueType);
        }

        public boolean isStale() {
            ObservableTracker.getterCalled((IObservable)this);
            return this.stale;
        }

        public void setStale(boolean stale) {
            if (this.stale != stale) {
                this.stale = stale;
                if (stale) {
                    this.fireStale();
                } else {
                    this.fireValueChange(Diffs.createValueDiff((Object)this.doGetValue(), (Object)this.doGetValue()));
                }
            }
        }

        protected void fireStale() {
            super.fireStale();
        }
    }
}

