/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding;

import org.eclipse.core.databinding.BindingProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.internal.databinding.conversion.ObjectToStringConverter;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConverterValuePropertyTest
extends AbstractDefaultRealmTestCase {
    private IConverter<Object, String> converter;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.converter = new ObjectToStringConverter(Integer.class);
    }

    @Test
    public void testGetValue() {
        IValueProperty property = BindingProperties.convertedValue(this.converter);
        Assert.assertEquals((Object)"123", (Object)property.getValue((Object)123));
    }

    @Test
    public void testGetValueForNullSource() {
        IValueProperty property = BindingProperties.convertedValue(this.converter);
        Assert.assertEquals((Object)"", (Object)property.getValue(null));
    }

    @Test
    public void testSetValue() {
        IValueProperty property = BindingProperties.convertedValue(this.converter);
        Assert.assertThrows((String)"setting a value should trigger an exception!", UnsupportedOperationException.class, () -> property.setValue((Object)123, (Object)"123"));
    }

    @Test
    public void testGetValueType() {
        IValueProperty property = BindingProperties.convertedValue(this.converter);
        Assert.assertEquals((Object)this.converter.getToType(), (Object)property.getValueType());
    }
}

