/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding;

import org.eclipse.core.databinding.conversion.EnumConverters;
import org.eclipse.core.databinding.conversion.IConverter;
import org.junit.Assert;
import org.junit.Test;

public class EnumConvertersTest {
    @Test
    public void testFromOrdinal() {
        IConverter fromOrdinal = EnumConverters.fromOrdinal(TestEnum.class);
        Assert.assertEquals((Object)((Object)TestEnum.A), (Object)fromOrdinal.convert((Object)0));
        Assert.assertEquals(null, (Object)fromOrdinal.convert(null));
        Assert.assertEquals(null, (Object)fromOrdinal.convert((Object)100));
        Assert.assertEquals(Integer.class, (Object)fromOrdinal.getFromType());
        Assert.assertEquals(TestEnum.class, (Object)fromOrdinal.getToType());
    }

    @Test
    public void testFromString() {
        IConverter fromOrdinal = EnumConverters.fromString(TestEnum.class);
        Assert.assertEquals((Object)((Object)TestEnum.A), (Object)fromOrdinal.convert((Object)"A"));
        Assert.assertEquals(null, (Object)fromOrdinal.convert((Object)"a"));
        Assert.assertEquals(null, (Object)fromOrdinal.convert(null));
        Assert.assertEquals(String.class, (Object)fromOrdinal.getFromType());
        Assert.assertEquals(TestEnum.class, (Object)fromOrdinal.getToType());
    }

    @Test
    public void testToString() {
        IConverter fromOrdinal = EnumConverters.toString(TestEnum.class);
        Assert.assertEquals((Object)"a", (Object)fromOrdinal.convert((Object)TestEnum.A));
        Assert.assertEquals(null, (Object)fromOrdinal.convert(null));
        Assert.assertEquals(TestEnum.class, (Object)fromOrdinal.getFromType());
        Assert.assertEquals(String.class, (Object)fromOrdinal.getToType());
    }

    @Test
    public void testToOrdinal() {
        IConverter converter = EnumConverters.toOrdinal(TestEnum.class);
        Assert.assertEquals((long)0L, (long)((Integer)converter.convert((Object)TestEnum.A)).intValue());
        Assert.assertEquals(null, (Object)converter.convert(null));
        Assert.assertEquals(TestEnum.class, (Object)converter.getFromType());
        Assert.assertEquals(Integer.class, (Object)converter.getToType());
    }

    static enum TestEnum {
        A,
        B;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

