/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.core.databinding.util.ILogger;
import org.eclipse.core.databinding.util.Policy;
import org.eclipse.core.internal.databinding.beans.BeanPropertyListenerSupport;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BeanPropertyListenerSupportTest
extends AbstractDefaultRealmTestCase {
    private PropertyChangeListenerStub listener;
    private String propertyName;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.listener = new PropertyChangeListenerStub();
        this.propertyName = "value";
    }

    @Test
    public void testAddPropertyChangeListenerWithPropertyName() throws Exception {
        SpecificListenerBean bean = new SpecificListenerBean();
        Assert.assertFalse((boolean)bean.changeSupport.hasListeners(this.propertyName));
        BeanPropertyListenerSupport.hookListener((Object)bean, (String)this.propertyName, (PropertyChangeListener)this.listener);
        Assert.assertTrue((String)"has listeners", (boolean)bean.changeSupport.hasListeners(this.propertyName));
    }

    @Test
    public void testAddPropertyChangeListenerWithoutPropertyName() throws Exception {
        GenericListenerBean bean = new GenericListenerBean();
        Assert.assertFalse((boolean)bean.changeSupport.hasListeners(this.propertyName));
        BeanPropertyListenerSupport.hookListener((Object)bean, (String)this.propertyName, (PropertyChangeListener)this.listener);
        Assert.assertTrue((String)"has listeners", (boolean)bean.changeSupport.hasListeners(this.propertyName));
    }

    @Test
    public void testLogStatusWhenAddPropertyChangeListenerMethodIsNotFound() throws Exception {
        class Log
        implements ILogger {
            int count;
            IStatus status;

            Log() {
            }

            public void log(IStatus status) {
                ++this.count;
                this.status = status;
            }
        }
        Log log = new Log();
        Policy.setLog((ILogger)log);
        class BeanStub {
            BeanStub() {
            }
        }
        BeanStub bean = new BeanStub();
        Assert.assertEquals((long)0L, (long)log.count);
        BeanPropertyListenerSupport.hookListener((Object)bean, (String)"value", (PropertyChangeListener)this.listener);
        Assert.assertEquals((long)1L, (long)log.count);
        Assert.assertEquals((long)2L, (long)log.status.getSeverity());
    }

    @Test
    public void testRemovePropertyChangeListenerWithPropertyName() throws Exception {
        SpecificListenerBean bean = new SpecificListenerBean();
        BeanPropertyListenerSupport.hookListener((Object)bean, (String)this.propertyName, (PropertyChangeListener)this.listener);
        Assert.assertTrue((boolean)bean.changeSupport.hasListeners(this.propertyName));
        BeanPropertyListenerSupport.unhookListener((Object)bean, (String)this.propertyName, (PropertyChangeListener)this.listener);
        Assert.assertFalse((String)"has listeners", (boolean)bean.changeSupport.hasListeners(this.propertyName));
    }

    @Test
    public void testRemovePropertyChangeListenerWithoutPropertyName() throws Exception {
        GenericListenerBean bean = new GenericListenerBean();
        BeanPropertyListenerSupport.hookListener((Object)bean, (String)this.propertyName, (PropertyChangeListener)this.listener);
        Assert.assertTrue((boolean)bean.changeSupport.hasListeners(this.propertyName));
        BeanPropertyListenerSupport.unhookListener((Object)bean, (String)this.propertyName, (PropertyChangeListener)this.listener);
        Assert.assertFalse((String)"has listeners", (boolean)bean.changeSupport.hasListeners(this.propertyName));
    }

    @Test
    public void testLogStatusWhenRemovePropertyChangeListenerMethodIsNotFound() throws Exception {
        class Log
        implements ILogger {
            int count;
            IStatus status;

            Log() {
            }

            public void log(IStatus status) {
                ++this.count;
                this.status = status;
            }
        }
        Log log = new Log();
        Policy.setLog((ILogger)log);
        class InvalidBean {
            InvalidBean() {
            }
        }
        InvalidBean bean = new InvalidBean();
        BeanPropertyListenerSupport.hookListener((Object)bean, (String)"value", (PropertyChangeListener)this.listener);
        log.count = 0;
        log.status = null;
        Assert.assertEquals((long)0L, (long)log.count);
        BeanPropertyListenerSupport.unhookListener((Object)bean, (String)"value", (PropertyChangeListener)this.listener);
        Assert.assertEquals((long)1L, (long)log.count);
        Assert.assertEquals((long)2L, (long)log.status.getSeverity());
    }

    static class GenericListenerBean {
        private String other;
        PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
        private String value;

        GenericListenerBean() {
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
            this.changeSupport.firePropertyChange("value", this.value, this.value);
        }

        public String getOther() {
            return this.other;
        }

        public void setOther(String other) {
            this.other = other;
            this.changeSupport.firePropertyChange("other", this.other, this.other);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.changeSupport.removePropertyChangeListener(listener);
        }
    }

    static class PropertyChangeListenerStub
    implements PropertyChangeListener {
        PropertyChangeEvent event;
        int count;

        PropertyChangeListenerStub() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ++this.count;
            this.event = evt;
        }
    }

    static class SpecificListenerBean {
        PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
        String propertyName;
        String value;

        SpecificListenerBean() {
        }

        public void addPropertyChangeListener(String name, PropertyChangeListener listener) {
            this.propertyName = name;
            this.changeSupport.addPropertyChangeListener(name, listener);
        }

        public void removePropertyChangeListener(String name, PropertyChangeListener listener) {
            this.changeSupport.removePropertyChangeListener(name, listener);
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

