/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.conversion;

import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.internal.databinding.conversion.IdentityConverter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IdentityConverterTest {
    private IdentityConverter c;

    @Before
    public void setUp() throws Exception {
        this.c = new IdentityConverter(Integer.TYPE, Integer.TYPE);
    }

    @Test
    public void testIsPrimitiveTypeMatchedWithBoxed() throws Exception {
        Assert.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Integer.class, Integer.TYPE));
        Assert.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Integer.TYPE, Integer.class));
        Assert.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Byte.class, Byte.TYPE));
        Assert.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Byte.TYPE, Byte.class));
        Assert.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Short.class, Short.TYPE));
        Assert.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Short.TYPE, Short.class));
        Assert.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Long.class, Long.TYPE));
        Assert.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Long.TYPE, Long.class));
        Assert.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Float.class, Float.TYPE));
        Assert.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Float.TYPE, Float.class));
        Assert.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Double.class, Double.TYPE));
        Assert.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Double.TYPE, Double.class));
        Assert.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Boolean.class, Boolean.TYPE));
        Assert.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Boolean.TYPE, Boolean.class));
        Assert.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Character.class, Character.TYPE));
        Assert.assertTrue((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Character.TYPE, Character.class));
        Assert.assertFalse((boolean)this.c.isPrimitiveTypeMatchedWithBoxed(Boolean.class, Integer.TYPE));
    }

    @Test
    public void testConvert_NullToPrimitive() {
        IdentityConverter p2b = new IdentityConverter(Float.TYPE, Float.TYPE);
        Assert.assertThrows(BindingException.class, () -> {
            Object object = p2b.convert(null);
        });
    }

    @Test
    public void testConvert_PrimitiveToBoxed() throws Exception {
        IdentityConverter p2b = new IdentityConverter(Float.TYPE, Float.class);
        Assert.assertEquals((String)"4.2", (Object)Float.valueOf(4.2f), (Object)p2b.convert((Object)Float.valueOf(4.2f)));
    }

    @Test
    public void testConvert_BoxedToPrimitive() throws Exception {
        IdentityConverter p2b = new IdentityConverter(Float.class, Float.TYPE);
        Assert.assertEquals((String)"4.2", (Object)Float.valueOf(4.2f), (Object)p2b.convert((Object)Float.valueOf(4.2f)));
    }

    @Test
    public void testConvert_PrimitiveToPrimitive() throws Exception {
        IdentityConverter p2b = new IdentityConverter(Float.TYPE, Float.TYPE);
        Assert.assertEquals((String)"4.2", (Object)Float.valueOf(4.2f), (Object)p2b.convert((Object)Float.valueOf(4.2f)));
    }

    @Test
    public void testConvert_BoxedToBoxed() throws Exception {
        IdentityConverter p2b = new IdentityConverter(Float.class, Float.class);
        Assert.assertEquals((String)"4.2", (Object)Float.valueOf(4.2f), (Object)p2b.convert((Object)Float.valueOf(4.2f)));
    }

    @Test
    public void test_Convert_ValidAssignment() throws Exception {
        IdentityConverter pc = new IdentityConverter(Object.class, Person.class);
        Person orig = new Person();
        Object person = pc.convert((Object)orig);
        Assert.assertTrue((String)"Person class", (boolean)person.getClass().equals(Person.class));
        Assert.assertTrue((String)"Need correct Person", (boolean)person.equals(orig));
    }

    @Test
    public void test_Convert_ValidAssignment2() throws Exception {
        IdentityConverter pc = new IdentityConverter(Person.class, Object.class);
        Person orig = new Person();
        Object person = pc.convert((Object)orig);
        Assert.assertTrue((String)"Person class", (boolean)person.getClass().equals(Person.class));
        Assert.assertTrue((String)"Need correct Person", (boolean)person.equals(orig));
    }

    @Test
    public void testConvert_InvalidAssignment() throws Exception {
        IdentityConverter pc = new IdentityConverter(Object.class, Person.class);
        Assert.assertThrows(BindingException.class, () -> {
            Object object = pc.convert((Object)new Animal());
        });
    }

    public static class Animal {
        public String name = "fido";
    }

    public static class Person {
        public String foo = "blah";
    }
}

