/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.conversion;

import java.text.Format;
import java.text.NumberFormat;
import org.eclipse.core.internal.databinding.conversion.IntegerToStringConverter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IntegerToStringConverterTest {
    private NumberFormat integerFormat;

    @Before
    public void setUp() {
        this.integerFormat = NumberFormat.getIntegerInstance();
    }

    @Test
    public void testFromTypeShort() throws Exception {
        Assert.assertEquals(Short.class, (Object)IntegerToStringConverter.fromShort((boolean)false).getFromType());
        Assert.assertEquals(Short.TYPE, (Object)IntegerToStringConverter.fromShort((boolean)true).getFromType());
        Assert.assertEquals(Byte.class, (Object)IntegerToStringConverter.fromByte((boolean)false).getFromType());
        Assert.assertEquals(Byte.TYPE, (Object)IntegerToStringConverter.fromByte((boolean)true).getFromType());
    }

    @Test
    public void testToTypeIsStringClass() throws Exception {
        Assert.assertEquals(String.class, (Object)IntegerToStringConverter.fromShort((boolean)false).getToType());
    }

    @Test
    public void testConvertShortToString() throws Exception {
        Short value = 1;
        String expected = this.integerFormat.format(value);
        IntegerToStringConverter converter = IntegerToStringConverter.fromShort((Format)this.integerFormat, (boolean)false);
        String result = converter.convert((Object)value);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testConvertByteToString() throws Exception {
        Byte value = 1;
        String expected = this.integerFormat.format(value);
        IntegerToStringConverter converter = IntegerToStringConverter.fromByte((Format)this.integerFormat, (boolean)false);
        String result = converter.convert((Object)value);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testNullSourceConvertsToEmptyString() throws Exception {
        IntegerToStringConverter converter = IntegerToStringConverter.fromByte((boolean)false);
        Assert.assertEquals((Object)"", (Object)converter.convert(null));
    }

    @Test
    public void testIllegalArgumentExceptionIfSourceIsNotExpectedType() throws Exception {
        IntegerToStringConverter converter = IntegerToStringConverter.fromByte((boolean)false);
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            String string = converter.convert((Object)1);
        });
    }
}

