/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.conversion;

import org.eclipse.core.databinding.conversion.IConverter;
import org.junit.Assert;
import org.junit.Test;

public abstract class NumberToNumberTestHarness {
    protected abstract IConverter<Object, ? extends Number> doGetToPrimitiveValidator(Class<?> var1);

    protected abstract IConverter<Object, ? extends Number> doGetToBoxedTypeValidator(Class<?> var1);

    protected abstract Class<?> doGetToType(boolean var1);

    protected abstract Number doGetOutOfRangeNumber();

    @Test
    public void testFromType() throws Exception {
        Class<Integer> from = Integer.class;
        Assert.assertEquals(from, (Object)this.doGetToBoxedTypeValidator(from).getFromType());
    }

    @Test
    public void testToTypeIsPrimitive() throws Exception {
        Class<?> toType = this.doGetToType(true);
        if (toType == null) {
            return;
        }
        Assert.assertEquals((String)"to type was not of the correct type", toType, (Object)this.doGetToPrimitiveValidator(Integer.class).getToType());
        Assert.assertTrue((String)"to type was not primitive", (boolean)toType.isPrimitive());
    }

    @Test
    public void testToTypeIsBoxedType() throws Exception {
        Class<?> toType = this.doGetToType(false);
        Assert.assertEquals(toType, (Object)this.doGetToBoxedTypeValidator(Integer.class).getToType());
        Assert.assertFalse((boolean)toType.isPrimitive());
    }

    @Test
    public void testValidConversion() throws Exception {
        Integer value = 1;
        Number result = (Number)this.doGetToBoxedTypeValidator(Integer.class).convert((Object)value);
        Assert.assertNotNull((String)"result was null", (Object)result);
        Assert.assertEquals(this.doGetToType(false), result.getClass());
        Assert.assertEquals((Object)value, (Object)result.intValue());
    }

    @Test
    public void testOutOfRangeConversion() throws Exception {
        Number outOfRange = this.doGetOutOfRangeNumber();
        if (outOfRange == null) {
            return;
        }
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Object object = this.doGetToBoxedTypeValidator(Integer.class).convert((Object)outOfRange);
        });
    }

    @Test
    public void testConvertNullValueForPrimitiveThrowsIllegalArgumentException() throws Exception {
        if (this.doGetToType(true) == null) {
            return;
        }
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Object object = this.doGetToPrimitiveValidator(Integer.class).convert(null);
        });
    }

    @Test
    public void testConvertNullValueForBoxedTypeReturnsNull() throws Exception {
        Assert.assertNull((Object)this.doGetToBoxedTypeValidator(Integer.class).convert(null));
    }

    @Test
    public void testNonNumberThrowsIllegalArgumentException() throws Exception {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Object object = this.doGetToBoxedTypeValidator(Integer.class).convert((Object)"");
        });
    }
}

