/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.conversion;

import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.internal.databinding.conversion.StatusToStringConverter;
import org.eclipse.core.runtime.IStatus;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StatusToStringConverterTest {
    private StatusToStringConverter converter;

    @Before
    public void setUp() throws Exception {
        this.converter = new StatusToStringConverter();
    }

    @Test
    public void testConvertedValueIsMessageOfStatus() throws Exception {
        String message = "this is my message";
        IStatus status = ValidationStatus.error((String)message);
        Assert.assertEquals((Object)message, (Object)this.converter.convert(status));
    }

    @Test
    public void testFromTypeIsIStatus() throws Exception {
        Assert.assertEquals(IStatus.class, (Object)this.converter.getFromType());
    }

    @Test
    public void testToTypeIsString() throws Exception {
        Assert.assertEquals(String.class, (Object)this.converter.getToType());
    }

    @Test
    public void testIllegalArgumentExceptionIsThrownWithNullInput() throws Exception {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            String string = this.converter.convert(null);
        });
    }
}

