/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.conversion;

import java.text.Format;
import java.text.NumberFormat;
import org.eclipse.core.internal.databinding.conversion.StringToByteConverter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StringToByteConverterTest {
    private NumberFormat numberFormat;
    private StringToByteConverter converter;

    @Before
    public void setUp() {
        this.numberFormat = NumberFormat.getIntegerInstance();
        this.converter = StringToByteConverter.toByte((Format)this.numberFormat, (boolean)false);
    }

    @Test
    public void testConvertsToByte() {
        Byte value = 1;
        Byte result = this.converter.convert((Object)this.numberFormat.format(value));
        Assert.assertEquals((Object)value, (Object)result);
    }

    @Test
    public void testConvertsToBytePrimitive() {
        this.converter = StringToByteConverter.toByte((Format)this.numberFormat, (boolean)true);
        Byte value = 1;
        Byte result = this.converter.convert((Object)this.numberFormat.format(value));
        Assert.assertEquals((Object)value, (Object)result);
    }

    @Test
    public void testFromTypeIsString() {
        Assert.assertEquals(String.class, (Object)this.converter.getFromType());
    }

    @Test
    public void testToTypeIsShort() {
        Assert.assertEquals(Byte.class, (Object)this.converter.getToType());
    }

    @Test
    public void testToTypeIsBytePrimitive() {
        this.converter = StringToByteConverter.toByte((boolean)true);
        Assert.assertEquals(Byte.TYPE, (Object)this.converter.getToType());
    }

    @Test
    public void testReturnsNullBoxedTypeForEmptyString() {
        Assert.assertNull((Object)this.converter.convert((Object)""));
    }

    @Test
    public void testThrowsIllegalArgumentExceptionIfAskedToConvertNonString() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Object object = this.converter.convert((Object)1);
        });
    }
}

