/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.conversion;

import org.eclipse.core.internal.databinding.conversion.StringToCharacterConverter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StringToCharacterConverterTest {
    private StringToCharacterConverter converter;
    private StringToCharacterConverter primitiveConverter;

    @Before
    public void setUp() throws Exception {
        this.converter = StringToCharacterConverter.toCharacter((boolean)false);
        this.primitiveConverter = StringToCharacterConverter.toCharacter((boolean)true);
    }

    @Test
    public void testConvertsToCharacter() throws Exception {
        Character value = Character.valueOf('X');
        Character result = this.converter.convert((Object)Character.toString(value.charValue()));
        Assert.assertEquals((Object)value, (Object)result);
    }

    @Test
    public void testConvertsToCharacterPrimitive() throws Exception {
        Character value = Character.valueOf('Y');
        Character result = this.primitiveConverter.convert((Object)String.valueOf(value.charValue()));
        Assert.assertEquals((Object)value, (Object)result);
    }

    @Test
    public void testFromTypeIsString() throws Exception {
        Assert.assertEquals(String.class, (Object)this.converter.getFromType());
    }

    @Test
    public void testToTypeIsCharacter() throws Exception {
        Assert.assertEquals(Character.class, (Object)this.converter.getToType());
    }

    @Test
    public void testToTypeIsCharacterPrimitive() throws Exception {
        Assert.assertEquals(Character.TYPE, (Object)this.primitiveConverter.getToType());
    }

    @Test
    public void testReturnsNullBoxedTypeForEmptyString() throws Exception {
        Assert.assertNull((Object)this.converter.convert((Object)""));
    }

    @Test
    public void testNullCharacterIsOK() throws Exception {
        Assert.assertNull((Object)this.converter.convert(null));
    }

    @Test
    public void testNullCharacterIsNotOKForPrimitive() throws Exception {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Character c = this.primitiveConverter.convert(null);
        });
    }

    @Test
    public void testThrowsIllegalArgumentExceptionIfAskedToConvertNonString() throws Exception {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Character c = this.converter.convert((Object)1);
        });
    }
}

