/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.conversion;

import java.text.Format;
import java.text.NumberFormat;
import org.eclipse.core.internal.databinding.conversion.StringToNumberParser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StringToNumberParserTest {
    private NumberFormat integerFormat;

    @Before
    public void setUp() throws Exception {
        this.integerFormat = NumberFormat.getIntegerInstance();
    }

    @Test
    public void testParseNonStringThrowsIllegalArgumentException() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            StringToNumberParser.ParseResult parseResult = StringToNumberParser.parse((Object)0, (Format)this.integerFormat, (boolean)false);
        });
    }

    @Test
    public void testEmptyStringReturnsNullIfNotPrimitive() {
        StringToNumberParser.ParseResult result = StringToNumberParser.parse((Object)"", (Format)this.integerFormat, (boolean)false);
        Assert.assertNull((Object)result.getNumber());
    }

    @Test
    public void testReturnsParsePositionWhenValueCannotBeParsed() {
        StringToNumberParser.ParseResult result = StringToNumberParser.parse((Object)"adsf", (Format)this.integerFormat, (boolean)false);
        Assert.assertNotNull((Object)result.getPosition());
        Assert.assertNull((Object)result.getNumber());
    }

    @Test
    public void testReturnsNumberWhenSuccessfullyParsed() {
        Integer number = 5;
        StringToNumberParser.ParseResult result = StringToNumberParser.parse((Object)this.integerFormat.format(number.longValue()), (Format)this.integerFormat, (boolean)false);
        Assert.assertNull((Object)result.getPosition());
        Assert.assertEquals((long)number.intValue(), (long)result.getNumber().intValue());
    }
}

