/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.conversion;

import java.text.Format;
import java.text.NumberFormat;
import org.eclipse.core.internal.databinding.conversion.StringToShortConverter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StringToShortConverterTest {
    private NumberFormat numberFormat;
    private StringToShortConverter converter;

    @Before
    public void setUp() {
        this.numberFormat = NumberFormat.getIntegerInstance();
        this.converter = StringToShortConverter.toShort((Format)this.numberFormat, (boolean)false);
    }

    @Test
    public void testConvertsToShort() {
        Short value = 1;
        Short result = this.converter.convert((Object)this.numberFormat.format(value));
        Assert.assertEquals((Object)value, (Object)result);
    }

    @Test
    public void testConvertsToShortPrimitive() {
        this.converter = StringToShortConverter.toShort((Format)this.numberFormat, (boolean)true);
        Short value = 1;
        Short result = this.converter.convert((Object)this.numberFormat.format(value));
        Assert.assertEquals((Object)value, (Object)result);
    }

    @Test
    public void testFromTypeIsString() {
        Assert.assertEquals(String.class, (Object)this.converter.getFromType());
    }

    @Test
    public void testToTypeIsShort() {
        Assert.assertEquals(Short.class, (Object)this.converter.getToType());
    }

    @Test
    public void testToTypeIsShortPrimitive() {
        this.converter = StringToShortConverter.toShort((boolean)true);
        Assert.assertEquals(Short.TYPE, (Object)this.converter.getToType());
    }

    @Test
    public void testReturnsNullBoxedTypeForEmptyString() {
        Assert.assertNull((Object)this.converter.convert((Object)""));
    }

    @Test
    public void testThrowsIllegalArgumentExceptionIfAskedToConvertNonString() {
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Object object = this.converter.convert((Object)1);
        });
    }
}

