/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.observable;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.WritableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.core.internal.databinding.observable.MapEntryObservableValue;
import org.eclipse.jface.databinding.conformance.MutableObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.ObservableStaleContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.util.TestCollection;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MapEntryObservableValueTest
extends AbstractDefaultRealmTestCase
implements IValueChangeListener {
    private static final String VALUE1 = "Value1";
    private static final String VALUE2 = "Value2";
    private final Object key = "mapKey";
    private IObservableMap map;
    private ValueDiff diff;
    private MapEntryObservableValue observedValue;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.map = new WritableMap();
        this.observedValue = (MapEntryObservableValue)Observables.observeMapEntry((IObservableMap)this.map, (Object)this.key, String.class);
        this.observedValue.addValueChangeListener((IValueChangeListener)this);
    }

    public void handleValueChange(ValueChangeEvent p_event) {
        this.diff = p_event.diff;
    }

    @Test
    public void testNullValue() {
        this.map.put(this.key, null);
        Assert.assertNull((Object)this.diff);
        Assert.assertNull((Object)this.observedValue.getValue());
        this.map.put(this.key, null);
        Assert.assertNull((Object)this.diff);
        Assert.assertNull((Object)this.observedValue.getValue());
        this.map.remove(this.key);
        Assert.assertNull((Object)this.diff);
        Assert.assertNull((Object)this.observedValue.getValue());
    }

    @Test
    public void testNonNullValue() {
        this.map.put(this.key, (Object)VALUE1);
        Assert.assertNotNull((Object)this.diff);
        Assert.assertNull((Object)this.diff.getOldValue());
        Assert.assertSame((Object)VALUE1, (Object)this.diff.getNewValue());
        Assert.assertSame((Object)VALUE1, (Object)this.observedValue.getValue());
        this.diff = null;
        this.map.put(this.key, (Object)VALUE2);
        Assert.assertNotNull((Object)this.diff);
        Assert.assertSame((Object)VALUE1, (Object)this.diff.getOldValue());
        Assert.assertSame((Object)VALUE2, (Object)this.diff.getNewValue());
        Assert.assertSame((Object)VALUE2, (Object)this.observedValue.getValue());
    }

    @Test
    public void testTransitionBetweenNullAndNonNull() {
        this.map.put(this.key, null);
        this.diff = null;
        this.map.put(this.key, (Object)VALUE1);
        Assert.assertNotNull((Object)this.diff);
        Assert.assertNull((Object)this.diff.getOldValue());
        Assert.assertSame((Object)VALUE1, (Object)this.diff.getNewValue());
        this.diff = null;
        this.map.put(this.key, null);
        Assert.assertNotNull((Object)this.diff);
        Assert.assertSame((Object)VALUE1, (Object)this.diff.getOldValue());
        Assert.assertNull((Object)this.diff.getNewValue());
    }

    @Test
    public void testRemoveKey() {
        this.map.put(this.key, (Object)VALUE1);
        this.diff = null;
        this.map.remove(this.key);
        Assert.assertNotNull((Object)this.diff);
        Assert.assertSame((Object)VALUE1, (Object)this.diff.getOldValue());
        Assert.assertNull((Object)this.diff.getNewValue());
    }

    @Test
    public void testGetAndSetValue() {
        this.observedValue.setValue(null);
        Assert.assertNull((Object)this.observedValue.getValue());
        Assert.assertNull((Object)this.diff);
        this.observedValue.setValue((Object)VALUE1);
        Assert.assertSame((Object)VALUE1, (Object)this.observedValue.getValue());
        Assert.assertNotNull((Object)this.diff);
        Assert.assertNull((Object)this.diff.getOldValue());
        Assert.assertSame((Object)VALUE1, (Object)this.diff.getNewValue());
        this.diff = null;
        this.observedValue.setValue((Object)VALUE2);
        Assert.assertSame((Object)VALUE2, (Object)this.observedValue.getValue());
        Assert.assertNotNull((Object)this.diff);
        Assert.assertSame((Object)VALUE1, (Object)this.diff.getOldValue());
        Assert.assertSame((Object)VALUE2, (Object)this.diff.getNewValue());
    }

    public static void addConformanceTest(TestCollection suite) {
        suite.addTest(MutableObservableValueContractTest.class, (Object)new Delegate());
        suite.addTest(ObservableStaleContractTest.class, (Object)new Delegate());
    }

    private static class Delegate
    extends AbstractObservableValueContractDelegate {
        private final Object valueType = new Object();

        private Delegate() {
        }

        public IObservableValue createObservableValue(Realm realm) {
            WritableMap map = new WritableMap(realm);
            Object key = new Object();
            map.put(key, new Object());
            return new MapEntryObservableValueStub(map, key, this.valueType);
        }

        public Object createValue(IObservableValue observable) {
            return new Object();
        }

        public Object getValueType(IObservableValue observable) {
            return this.valueType;
        }

        public void change(IObservable observable) {
            MapEntryObservableValueStub mapEntryValue = (MapEntryObservableValueStub)observable;
            mapEntryValue.map.put(mapEntryValue.key, this.createValue((IObservableValue)mapEntryValue));
        }

        public void setStale(IObservable observable, boolean stale) {
            MapEntryObservableValueStub mapEntryValue = (MapEntryObservableValueStub)observable;
            mapEntryValue.map.setStale(stale);
        }
    }

    private static class MapEntryObservableValueStub
    extends MapEntryObservableValue {
        WritableMap map;
        Object key;

        MapEntryObservableValueStub(WritableMap map, Object key, Object valueType) {
            super((IObservableMap)map, key, valueType);
            this.map = map;
            this.key = key;
        }
    }
}

