/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.observable;

import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.databinding.observable.AbstractObservable;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.internal.databinding.observable.StalenessObservableValue;
import org.eclipse.jface.databinding.conformance.ObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.util.TestCollection;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Test;

public class StalenessObservableValueTest
extends AbstractDefaultRealmTestCase {
    @Test
    public void valueDuringListenerCallback() {
        WritableValue source = new WritableValue((Object)"a", String.class);
        IObservableValue delayed = Observables.observeDelayedValue((int)1, (IObservableValue)source);
        IObservableValue stale = Observables.observeStale((IObservable)delayed);
        AtomicInteger nrStaleEvents = new AtomicInteger();
        stale.addValueChangeListener(e -> {
            if (nrStaleEvents.incrementAndGet() == 1) {
                Assert.assertTrue((boolean)((Boolean)stale.getValue()));
                Assert.assertTrue((boolean)((Boolean)e.diff.getNewValue()));
                Assert.assertFalse((boolean)((Boolean)e.diff.getOldValue()));
            } else {
                Assert.assertFalse((boolean)((Boolean)stale.getValue()));
                Assert.assertFalse((boolean)((Boolean)e.diff.getNewValue()));
                Assert.assertTrue((boolean)((Boolean)e.diff.getOldValue()));
            }
        });
        source.setValue((Object)"b");
        delayed.getValue();
        Assert.assertEquals((long)2L, (long)nrStaleEvents.get());
    }

    public static void addConformanceTest(TestCollection suite) {
        suite.addTest(ObservableValueContractTest.class, (Object)new Delegate());
    }

    static class Delegate
    extends AbstractObservableValueContractDelegate {
        Delegate() {
        }

        public IObservableValue<?> createObservableValue(Realm realm) {
            return new StalenessObservableValueStub(new ObservableStub(realm));
        }

        public void change(IObservable observable) {
            ObservableStub target;
            target.setStale(!(target = ((StalenessObservableValueStub)observable).target).isStale());
        }

        public Object getValueType(IObservableValue<?> observable) {
            return Boolean.TYPE;
        }
    }

    static class ObservableStub
    extends AbstractObservable {
        boolean stale;

        public ObservableStub(Realm realm) {
            super(realm);
        }

        public boolean isStale() {
            return this.stale;
        }

        public void setStale(boolean stale) {
            if (this.stale == stale) {
                return;
            }
            this.stale = stale;
            if (stale) {
                this.fireStale();
            } else {
                this.fireChange();
            }
        }
    }

    static class StalenessObservableValueStub
    extends StalenessObservableValue {
        ObservableStub target;

        StalenessObservableValueStub(ObservableStub target) {
            super((IObservable)target);
            this.target = target;
        }
    }
}

