/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.observable;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.list.ObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.internal.databinding.observable.UnmodifiableObservableList;
import org.eclipse.jface.databinding.conformance.ObservableListContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.ChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.ListChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.StaleEventTracker;
import org.eclipse.jface.databinding.conformance.util.TestCollection;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UnmodifiableObservableListTest
extends AbstractDefaultRealmTestCase {
    IObservableList unmodifiable;
    ObservableList mutable;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        ArrayList<String> list = new ArrayList<String>();
        list.add("1");
        list.add("2");
        this.mutable = new MutableObservableList(list, String.class);
        this.unmodifiable = Observables.unmodifiableObservableList((IObservableList)this.mutable);
    }

    @Test
    public void testFiresChangeEvents() throws Exception {
        ChangeEventTracker mutableListener = new ChangeEventTracker();
        ChangeEventTracker unmodifiableListener = new ChangeEventTracker();
        this.mutable.addChangeListener((IChangeListener)mutableListener);
        this.unmodifiable.addChangeListener((IChangeListener)unmodifiableListener);
        Assert.assertEquals((long)0L, (long)mutableListener.count);
        Assert.assertEquals((long)0L, (long)unmodifiableListener.count);
        this.mutable.add((Object)"3");
        Assert.assertEquals((long)1L, (long)mutableListener.count);
        Assert.assertEquals((long)1L, (long)unmodifiableListener.count);
    }

    @Test
    public void testFiresListChangeEvents() throws Exception {
        ListChangeEventTracker mutableListener = new ListChangeEventTracker();
        ListChangeEventTracker unmodifiableListener = new ListChangeEventTracker();
        this.mutable.addListChangeListener((IListChangeListener)mutableListener);
        this.unmodifiable.addListChangeListener((IListChangeListener)unmodifiableListener);
        Assert.assertEquals((long)0L, (long)mutableListener.count);
        Assert.assertEquals((long)0L, (long)unmodifiableListener.count);
        String element = "3";
        this.mutable.add((Object)element);
        Assert.assertEquals((long)1L, (long)mutableListener.count);
        Assert.assertEquals((Object)this.mutable, (Object)mutableListener.event.getObservableList());
        Assert.assertEquals((long)1L, (long)mutableListener.event.diff.getDifferences().length);
        ListDiffEntry difference = mutableListener.event.diff.getDifferences()[0];
        Assert.assertEquals((Object)element, (Object)difference.getElement());
        Assert.assertTrue((boolean)difference.isAddition());
        Assert.assertEquals((long)3L, (long)this.mutable.size());
        Assert.assertEquals((long)1L, (long)unmodifiableListener.count);
        Assert.assertEquals((Object)this.unmodifiable, (Object)unmodifiableListener.event.getObservableList());
        Assert.assertEquals((long)1L, (long)unmodifiableListener.event.diff.getDifferences().length);
        difference = unmodifiableListener.event.diff.getDifferences()[0];
        Assert.assertEquals((Object)element, (Object)difference.getElement());
        Assert.assertTrue((boolean)difference.isAddition());
        Assert.assertEquals((long)3L, (long)this.unmodifiable.size());
    }

    @Test
    public void testFiresStaleEvents() throws Exception {
        StaleEventTracker mutableListener = new StaleEventTracker();
        StaleEventTracker unmodifiableListener = new StaleEventTracker();
        this.mutable.addStaleListener((IStaleListener)mutableListener);
        this.unmodifiable.addStaleListener((IStaleListener)unmodifiableListener);
        Assert.assertEquals((long)0L, (long)mutableListener.count);
        Assert.assertEquals((long)0L, (long)unmodifiableListener.count);
        this.mutable.setStale(true);
        Assert.assertEquals((long)1L, (long)mutableListener.count);
        Assert.assertEquals((Object)this.mutable, (Object)mutableListener.event.getObservable());
        Assert.assertTrue((boolean)this.mutable.isStale());
        Assert.assertEquals((long)1L, (long)unmodifiableListener.count);
        Assert.assertEquals((Object)this.unmodifiable, (Object)unmodifiableListener.event.getObservable());
        Assert.assertTrue((boolean)this.unmodifiable.isStale());
    }

    @Test
    public void testIsStale() throws Exception {
        Assert.assertFalse((boolean)this.mutable.isStale());
        Assert.assertFalse((boolean)this.unmodifiable.isStale());
        this.mutable.setStale(true);
        Assert.assertTrue((boolean)this.mutable.isStale());
        Assert.assertTrue((boolean)this.unmodifiable.isStale());
    }

    public static void addConformanceTest(TestCollection suite) {
        suite.addTest(ObservableListContractTest.class, (Object)new Delegate());
    }

    private static class Delegate
    extends AbstractObservableCollectionContractDelegate {
        private final Object elementType = new Object();

        private Delegate() {
        }

        public IObservableCollection createObservableCollection(Realm realm, int elementCount) {
            WritableList backingList = new WritableList(realm, new ArrayList(), this.elementType);
            UnmodifiableObservableListStub result = new UnmodifiableObservableListStub((IObservableList)backingList);
            int i = 0;
            while (i < elementCount) {
                backingList.add(this.createElement((IObservableCollection)result));
                ++i;
            }
            return result;
        }

        public Object createElement(IObservableCollection collection) {
            return new Object();
        }

        public Object getElementType(IObservableCollection collection) {
            return this.elementType;
        }

        public void change(IObservable observable) {
            UnmodifiableObservableListStub unmodifiableList = (UnmodifiableObservableListStub)observable;
            IObservableList wrappedList = unmodifiableList.wrappedList;
            wrappedList.add(this.createElement((IObservableCollection)unmodifiableList));
        }
    }

    private static class MutableObservableList
    extends ObservableList {
        public MutableObservableList(List wrappedList, Object elementType) {
            super(wrappedList, elementType);
        }

        public boolean add(Object o) {
            boolean result = this.wrappedList.add(o);
            this.fireListChange(Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)(this.wrappedList.size() - 1), (boolean)true, (Object)o)));
            return result;
        }
    }

    private static class UnmodifiableObservableListStub
    extends UnmodifiableObservableList {
        IObservableList wrappedList;

        UnmodifiableObservableListStub(IObservableList wrappedList) {
            super(wrappedList);
            this.wrappedList = wrappedList;
        }
    }
}

