/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.observable;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.internal.databinding.observable.UnmodifiableObservableValue;
import org.eclipse.jface.databinding.conformance.ObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.util.StaleEventTracker;
import org.eclipse.jface.databinding.conformance.util.TestCollection;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UnmodifiableObservableValueTest
extends AbstractDefaultRealmTestCase {
    private UnmodifiableObservableValueStub unmodifiable;

    public static void addConformanceTest(TestCollection suite) {
        suite.addTest(ObservableValueContractTest.class, (Object)new Delegate());
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        WrappedObservableValue wrapped = new WrappedObservableValue(Realm.getDefault(), null, String.class);
        this.unmodifiable = new UnmodifiableObservableValueStub(wrapped);
    }

    @Test
    public void testFiresStaleEvents() {
        StaleEventTracker wrappedListener = new StaleEventTracker();
        StaleEventTracker unmodifiableListener = new StaleEventTracker();
        this.unmodifiable.wrappedValue.addStaleListener((IStaleListener)wrappedListener);
        this.unmodifiable.addStaleListener((IStaleListener)unmodifiableListener);
        Assert.assertEquals((long)0L, (long)wrappedListener.count);
        Assert.assertEquals((long)0L, (long)unmodifiableListener.count);
        this.unmodifiable.wrappedValue.setStale(true);
        Assert.assertEquals((long)1L, (long)wrappedListener.count);
        Assert.assertEquals((Object)((Object)this.unmodifiable.wrappedValue), (Object)wrappedListener.event.getObservable());
        Assert.assertTrue((boolean)this.unmodifiable.wrappedValue.isStale());
        Assert.assertEquals((long)1L, (long)unmodifiableListener.count);
        Assert.assertEquals((Object)((Object)this.unmodifiable), (Object)unmodifiableListener.event.getObservable());
        Assert.assertTrue((boolean)this.unmodifiable.isStale());
    }

    @Test
    public void testIsStale() {
        Assert.assertFalse((boolean)this.unmodifiable.wrappedValue.isStale());
        Assert.assertFalse((boolean)this.unmodifiable.isStale());
        this.unmodifiable.wrappedValue.setStale(true);
        Assert.assertTrue((boolean)this.unmodifiable.wrappedValue.isStale());
        Assert.assertTrue((boolean)this.unmodifiable.isStale());
    }

    private static class Delegate
    extends AbstractObservableValueContractDelegate {
        private final Object valueType = new Object();

        private Delegate() {
        }

        public IObservableValue createObservableValue(Realm realm) {
            return new UnmodifiableObservableValueStub(new WrappedObservableValue(realm, null, this.valueType));
        }

        public Object getValueType(IObservableValue observable) {
            return this.valueType;
        }

        public Object createValue(IObservableValue observable) {
            return new Object();
        }

        public void change(IObservable observable) {
            UnmodifiableObservableValueStub wrapper = (UnmodifiableObservableValueStub)observable;
            wrapper.wrappedValue.setValue(this.createValue((IObservableValue)wrapper));
        }

        public void setStale(IObservable observable, boolean stale) {
            UnmodifiableObservableValueStub wrapper = (UnmodifiableObservableValueStub)observable;
            wrapper.wrappedValue.setStale(stale);
        }
    }

    private static class UnmodifiableObservableValueStub
    extends UnmodifiableObservableValue {
        WrappedObservableValue wrappedValue;

        UnmodifiableObservableValueStub(WrappedObservableValue wrappedValue) {
            super((IObservableValue)wrappedValue);
            this.wrappedValue = wrappedValue;
        }
    }

    private static class WrappedObservableValue
    extends WritableValue {
        private boolean stale = false;

        public WrappedObservableValue(Realm realm, Object initialValue, Object valueType) {
            super(realm, initialValue, valueType);
        }

        public boolean isStale() {
            ObservableTracker.getterCalled((IObservable)this);
            return this.stale;
        }

        public void setStale(boolean stale) {
            if (this.stale != stale) {
                this.stale = stale;
                if (stale) {
                    this.fireStale();
                } else {
                    this.fireValueChange(Diffs.createValueDiff((Object)this.getValue(), (Object)this.getValue()));
                }
            }
        }
    }
}

