/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.observable.masterdetail;

import java.util.HashSet;
import java.util.List;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.masterdetail.MasterDetailObservables;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.internal.databinding.observable.masterdetail.DetailObservableSet;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.jface.databinding.conformance.MutableObservableSetContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.DisposeEventTracker;
import org.eclipse.jface.databinding.conformance.util.TestCollection;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Test;

public class DetailObservableSetTest
extends AbstractDefaultRealmTestCase {
    @Test
    public void testElementTypeNull() throws Exception {
        WritableValue observableValue = new WritableValue((Object)new WritableSet(new HashSet(), Object.class), null);
        WritableSetFactory factory = new WritableSetFactory();
        DetailObservableSet detailObservable = new DetailObservableSet((IObservableFactory)factory, (IObservableValue)observableValue, null);
        Assert.assertNull((Object)detailObservable.getElementType());
        factory.type = Object.class;
        observableValue.setValue((Object)new WritableSet(List.of(new Object()), String.class));
        Assert.assertNull((String)"element type not null", (Object)detailObservable.getElementType());
        factory.type = String.class;
        observableValue.setValue((Object)new WritableSet(List.of("1"), Object.class));
        Assert.assertNull((String)"element type not null", (Object)detailObservable.getElementType());
    }

    @Test
    public void testElementTypeNotNull() throws Exception {
        WritableValue observableValue = new WritableValue((Object)new WritableSet(new HashSet(), Object.class), null);
        WritableSetFactory factory = new WritableSetFactory();
        DetailObservableSet detailObservable = new DetailObservableSet((IObservableFactory)factory, (IObservableValue)observableValue, Object.class);
        Assert.assertEquals((Object)factory.type, (Object)detailObservable.getElementType());
        factory.type = String.class;
        Assert.assertThrows((String)"if an element type is set this cannot be changed", AssertionFailedException.class, () -> observableValue.setValue((Object)new WritableSet(List.of(new Object()), String.class)));
    }

    @Test
    public void testMasterNotDisposedWhenDetailDisposed() {
        class OuterObservable
        extends WritableValue {
            boolean disposed = false;

            OuterObservable() {
            }

            public synchronized void dispose() {
                this.disposed = true;
                super.dispose();
            }
        }
        OuterObservable outerObservable = new OuterObservable();
        WritableSetFactory factory = new WritableSetFactory();
        DetailObservableSet detailObservable = new DetailObservableSet((IObservableFactory)factory, (IObservableValue)outerObservable, null);
        Assert.assertFalse((boolean)outerObservable.disposed);
        detailObservable.dispose();
        Assert.assertFalse((boolean)outerObservable.disposed);
    }

    @Test
    public void testDisposeMasterDisposesDetail() {
        WritableValue master = new WritableValue();
        WritableSetFactory factory = new WritableSetFactory();
        master.setValue((Object)"");
        IObservableSet detailObservable = MasterDetailObservables.detailSet((IObservableValue)master, (IObservableFactory)factory, null);
        DisposeEventTracker tracker = DisposeEventTracker.observe((IObservable)detailObservable);
        master.dispose();
        Assert.assertEquals((long)1L, (long)tracker.count);
        Assert.assertTrue((boolean)detailObservable.isDisposed());
    }

    @Test
    public void testDisposeWhileFiringEvents() {
        WritableValue master = new WritableValue();
        WritableSetFactory factory = new WritableSetFactory();
        master.setValue((Object)"");
        IObservableSet[] detailObservable = new IObservableSet[1];
        master.addValueChangeListener(event -> detailObservable[0].dispose());
        detailObservable[0] = MasterDetailObservables.detailSet((IObservableValue)master, (IObservableFactory)factory, null);
        master.setValue((Object)"New Value");
    }

    public static void addConformanceTest(TestCollection suite) {
        suite.addTest(MutableObservableSetContractTest.class, (Object)new Delegate());
    }

    static class Delegate
    extends AbstractObservableCollectionContractDelegate {
        Object elementType = Object.class;

        Delegate() {
        }

        public IObservableCollection createObservableCollection(Realm realm, int elementCount) {
            WritableValue master = new WritableValue(realm, (Object)elementCount, Integer.class);
            FactoryStub factory = new FactoryStub(realm, this.elementType);
            return new DetailObservableSetStub(factory, (IObservableValue)master, this.elementType);
        }

        public Object createElement(IObservableCollection collection) {
            return new Object();
        }

        public Object getElementType(IObservableCollection collection) {
            return this.elementType;
        }

        public void change(IObservable observable) {
            IObservableValue master = ((DetailObservableSetStub)observable).master;
            master.setValue((Object)((Integer)master.getValue() + 1));
        }
    }

    static class DetailObservableSetStub
    extends DetailObservableSet {
        IObservableValue master;

        DetailObservableSetStub(IObservableFactory factory, IObservableValue master, Object elementType) {
            super(factory, master, elementType);
            this.master = master;
        }
    }

    static class FactoryStub
    implements IObservableFactory {
        private final Realm realm;
        private final Object elementType;
        Object type = Object.class;

        FactoryStub(Realm realm, Object elementType) {
            this.realm = realm;
            this.elementType = elementType;
        }

        public IObservable createObservable(Object target) {
            int elementCount = (Integer)target;
            HashSet<Object> wrappedSet = new HashSet<Object>();
            int i = 0;
            while (i < elementCount) {
                wrappedSet.add(new Object());
                ++i;
            }
            return new WritableSet(this.realm, wrappedSet, this.elementType);
        }
    }

    private static class WritableSetFactory
    implements IObservableFactory {
        Object type = Object.class;

        private WritableSetFactory() {
        }

        public IObservable createObservable(Object target) {
            return new WritableSet(new HashSet(), this.type);
        }
    }
}

