/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.observable.masterdetail;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.masterdetail.MasterDetailObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.internal.databinding.observable.masterdetail.DetailObservableValue;
import org.eclipse.jface.databinding.conformance.MutableObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.util.CurrentRealm;
import org.eclipse.jface.databinding.conformance.util.DisposeEventTracker;
import org.eclipse.jface.databinding.conformance.util.RealmTester;
import org.eclipse.jface.databinding.conformance.util.TestCollection;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DetailObservableValueTest
extends AbstractDefaultRealmTestCase {
    private WritableValue outerObservable;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.outerObservable = new WritableValue();
    }

    @Test
    public void testSetValue() throws Exception {
        WritableValueFactory factory = new WritableValueFactory();
        this.outerObservable.setValue((Object)"");
        IObservableValue detailObservable = MasterDetailObservables.detailValue((IObservableValue)this.outerObservable, (IObservableFactory)factory, null);
        WritableValue innerObservable = factory.innerObservable;
        Object value = new Object();
        Assert.assertFalse((boolean)value.equals(innerObservable.getValue()));
        detailObservable.setValue(value);
        Assert.assertEquals((String)"inner value", (Object)value, (Object)innerObservable.getValue());
    }

    @Test
    public void testGetValueType() throws Exception {
        DetailObservableValue detailObservable = new DetailObservableValue((IObservableValue)this.outerObservable, null, String.class);
        Assert.assertEquals(String.class, (Object)detailObservable.getValueType());
    }

    @Test
    public void testGetValueTypeNullValueType() throws Exception {
        WritableValueFactory factory = new WritableValueFactory();
        DetailObservableValue detailObservable = new DetailObservableValue((IObservableValue)this.outerObservable, (IObservableFactory)factory, null);
        Assert.assertNull((Object)detailObservable.getValueType());
        factory.type = String.class;
        this.outerObservable.setValue((Object)"1");
        Assert.assertNull((String)"value type should be ignored", (Object)detailObservable.getValueType());
        factory.type = Object.class;
        this.outerObservable.setValue((Object)"2");
        Assert.assertNull((String)"value type should be ignored", (Object)detailObservable.getValueType());
    }

    @Test
    public void testMasterNotDisposedWhenDetailDisposed() {
        class OuterObservable
        extends WritableValue {
            boolean disposed = false;

            OuterObservable() {
            }

            public synchronized void dispose() {
                this.disposed = true;
                super.dispose();
            }
        }
        OuterObservable outerObservable = new OuterObservable();
        WritableValueFactory factory = new WritableValueFactory();
        DetailObservableValue detailObservable = new DetailObservableValue((IObservableValue)outerObservable, (IObservableFactory)factory, null);
        Assert.assertFalse((boolean)outerObservable.disposed);
        detailObservable.dispose();
        Assert.assertFalse((boolean)outerObservable.disposed);
    }

    @Test
    public void testDisposeMasterDisposesDetail() {
        WritableValue master = new WritableValue();
        WritableValueFactory factory = new WritableValueFactory();
        master.setValue((Object)"");
        IObservableValue detailObservable = MasterDetailObservables.detailValue((IObservableValue)master, (IObservableFactory)factory, null);
        DisposeEventTracker tracker = DisposeEventTracker.observe((IObservable)detailObservable);
        master.dispose();
        Assert.assertEquals((long)1L, (long)tracker.count);
        Assert.assertTrue((boolean)detailObservable.isDisposed());
    }

    @Test
    public void testDisposeWhileFiringEvents() {
        WritableValue master = new WritableValue();
        WritableValueFactory factory = new WritableValueFactory();
        master.setValue((Object)"");
        IObservableValue[] detailObservable = new IObservableValue[1];
        master.addValueChangeListener(event -> detailObservable[0].dispose());
        detailObservable[0] = MasterDetailObservables.detailValue((IObservableValue)master, (IObservableFactory)factory, null);
        master.setValue((Object)"New Value");
    }

    public static void addConformanceTest(TestCollection suite) {
        suite.addTest(MutableObservableValueContractTest.class, (Object)new Delegate());
    }

    private static class Delegate
    extends AbstractObservableValueContractDelegate {
        private Object valueType;
        private Realm previousRealm;

        private Delegate() {
        }

        public void setUp() {
            super.setUp();
            this.valueType = new Object();
            this.previousRealm = Realm.getDefault();
            RealmTester.setDefault((Realm)new CurrentRealm());
        }

        public void tearDown() {
            RealmTester.setDefault((Realm)this.previousRealm);
            super.tearDown();
        }

        public IObservableValue createObservableValue(Realm realm) {
            WritableValueFactory valueFactory = new WritableValueFactory();
            valueFactory.realm = realm;
            valueFactory.type = this.valueType;
            WritableValue masterObservableValue = new WritableValue(realm, new Object(), null);
            return new DetailObservableValueStub((IObservableValue)masterObservableValue, valueFactory, this.valueType);
        }

        public Object createValue(IObservableValue observable) {
            return new Object();
        }

        public Object getValueType(IObservableValue observable) {
            return this.valueType;
        }

        public void change(IObservable observable) {
            DetailObservableValueStub value = (DetailObservableValueStub)observable;
            value.outerObservableValue.setValue(this.createValue((IObservableValue)value));
        }
    }

    private static class DetailObservableValueStub
    extends DetailObservableValue {
        IObservableValue outerObservableValue;

        DetailObservableValueStub(IObservableValue outerObservableValue, IObservableFactory valueFactory, Object detailType) {
            super(outerObservableValue, valueFactory, detailType);
            this.outerObservableValue = outerObservableValue;
        }
    }

    static class WritableValueFactory
    implements IObservableFactory {
        Realm realm;
        WritableValue innerObservable;
        Object type;

        WritableValueFactory() {
        }

        public IObservable createObservable(Object target) {
            this.innerObservable = new WritableValue(this.realm == null ? Realm.getDefault() : this.realm, target, this.type);
            return this.innerObservable;
        }
    }
}

