/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.validation;

import org.eclipse.core.internal.databinding.conversion.StringToCharacterConverter;
import org.eclipse.core.internal.databinding.validation.StringToCharacterValidator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StringToCharacterValidatorTest {
    private StringToCharacterValidator validator;
    private StringToCharacterValidator primitiveValidator;

    @Before
    public void setUp() throws Exception {
        StringToCharacterConverter converter = StringToCharacterConverter.toCharacter((boolean)false);
        StringToCharacterConverter primitiveConverter = StringToCharacterConverter.toCharacter((boolean)true);
        this.validator = new StringToCharacterValidator(converter);
        this.primitiveValidator = new StringToCharacterValidator(primitiveConverter);
    }

    @Test
    public void testValidatesCharacter() throws Exception {
        Assert.assertTrue((boolean)this.validator.validate((Object)"X").isOK());
    }

    @Test
    public void testValidatesCharacterPrimitive() throws Exception {
        Assert.assertTrue((boolean)this.primitiveValidator.validate((Object)"X").isOK());
    }

    @Test
    public void testNullCharacterIsValid() throws Exception {
        Assert.assertTrue((boolean)this.validator.validate(null).isOK());
    }

    @Test
    public void testEmptyStringCharacterIsValid() throws Exception {
        Assert.assertTrue((boolean)this.validator.validate((Object)"").isOK());
    }

    @Test
    public void testNullCharacterIsInvalidForPrimitive() throws Exception {
        Assert.assertFalse((boolean)this.primitiveValidator.validate(null).isOK());
    }

    @Test
    public void testNonStringIsInvalid() throws Exception {
        Assert.assertFalse((boolean)this.primitiveValidator.validate((Object)4).isOK());
    }

    @Test
    public void testLongerThanOneCharacterIsInvalid() throws Exception {
        Assert.assertFalse((boolean)this.primitiveValidator.validate((Object)"XYZ").isOK());
    }
}

