/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.validation;

import java.math.BigDecimal;
import java.text.Format;
import java.text.NumberFormat;
import org.eclipse.core.databinding.conversion.text.StringToNumberConverter;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.internal.databinding.validation.NumberFormatConverter;
import org.eclipse.core.internal.databinding.validation.StringToDoubleValidator;
import org.eclipse.core.tests.internal.databinding.validation.StringToNumberValidatorTestHarness;

public class StringToDoubleValidatorTest
extends StringToNumberValidatorTestHarness {
    @Override
    protected Number getInRangeNumber() {
        return 1.0;
    }

    @Override
    protected String getInvalidString() {
        return "1a";
    }

    @Override
    protected Number getOutOfRangeNumber() {
        BigDecimal decimal = BigDecimal.valueOf(Double.MAX_VALUE);
        return decimal.add(BigDecimal.valueOf(Double.MAX_VALUE));
    }

    @Override
    protected NumberFormat setupNumberFormat() {
        return NumberFormat.getInstance();
    }

    @Override
    protected IValidator<Object> setupValidator(NumberFormat numberFormat) {
        StringToNumberConverter converter = StringToNumberConverter.toDouble((Format)numberFormat, (boolean)false);
        return new StringToDoubleValidator((NumberFormatConverter)converter);
    }
}

