/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.validation;

import java.text.Format;
import java.text.NumberFormat;
import org.eclipse.core.databinding.conversion.text.StringToNumberConverter;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.internal.databinding.validation.NumberFormatConverter;
import org.eclipse.core.internal.databinding.validation.StringToFloatValidator;
import org.eclipse.core.tests.internal.databinding.validation.StringToNumberValidatorTestHarness;

public class StringToFloatValidatorTest
extends StringToNumberValidatorTestHarness {
    @Override
    protected Number getInRangeNumber() {
        return Float.valueOf(1.0f);
    }

    @Override
    protected String getInvalidString() {
        return "1a";
    }

    @Override
    protected Number getOutOfRangeNumber() {
        return Double.MAX_VALUE;
    }

    @Override
    protected NumberFormat setupNumberFormat() {
        return NumberFormat.getInstance();
    }

    @Override
    protected IValidator<Object> setupValidator(NumberFormat numberFormat) {
        StringToNumberConverter converter = StringToNumberConverter.toFloat((Format)numberFormat, (boolean)false);
        return new StringToFloatValidator((NumberFormatConverter)converter);
    }
}

