/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.databinding.scenarios;

import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.examples.databinding.model.Adventure;
import org.eclipse.jface.examples.databinding.model.SampleData;
import org.eclipse.jface.tests.databinding.scenarios.ScenariosTestCase;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Widget;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ButtonControlScenario
extends ScenariosTestCase {
    private Adventure adventure;
    private Button button;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.button = new Button(this.getComposite(), 32);
        this.adventure = SampleData.WINTER_HOLIDAY;
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.button.dispose();
        super.tearDown();
    }

    @Test
    public void testScenario01() {
        this.getDbc().bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.button), BeanProperties.value((String)"petsAllowed").observe((Object)this.adventure));
        Assert.assertEquals((Object)this.button.getSelection(), (Object)this.adventure.isPetsAllowed());
        boolean newBoolean = !this.adventure.isPetsAllowed();
        this.adventure.setPetsAllowed(newBoolean);
        Assert.assertEquals((Object)newBoolean, (Object)this.adventure.isPetsAllowed());
        Assert.assertEquals((Object)this.button.getSelection(), (Object)newBoolean);
        newBoolean = !newBoolean;
        this.button.setSelection(newBoolean);
        this.button.notifyListeners(13, null);
        Assert.assertEquals((Object)newBoolean, (Object)this.adventure.isPetsAllowed());
        boolean finalNewBoolean = newBoolean = !newBoolean;
        this.adventure.setPetsAllowed(finalNewBoolean);
        this.spinEventLoop(0);
        Assert.assertEquals((Object)newBoolean, (Object)this.button.getSelection());
    }

    @Test
    public void testScenario02() {
        this.button.dispose();
        this.button = new Button(this.getComposite(), 2);
        this.getDbc().bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.button), BeanProperties.value((String)"petsAllowed").observe((Object)this.adventure));
        Assert.assertEquals((Object)this.button.getSelection(), (Object)this.adventure.isPetsAllowed());
        boolean newBoolean = !this.adventure.isPetsAllowed();
        this.adventure.setPetsAllowed(newBoolean);
        Assert.assertEquals((Object)newBoolean, (Object)this.adventure.isPetsAllowed());
        Assert.assertEquals((Object)this.button.getSelection(), (Object)newBoolean);
        newBoolean = !newBoolean;
        this.button.setSelection(newBoolean);
        this.button.notifyListeners(13, null);
        Assert.assertEquals((Object)newBoolean, (Object)this.adventure.isPetsAllowed());
    }

    @Test
    public void testScenario03() {
        this.button.dispose();
        this.button = new Button(this.getComposite(), 16);
        this.getDbc().bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.button), BeanProperties.value((String)"petsAllowed").observe((Object)this.adventure));
        Assert.assertEquals((Object)this.button.getSelection(), (Object)this.adventure.isPetsAllowed());
        boolean newBoolean = !this.adventure.isPetsAllowed();
        this.adventure.setPetsAllowed(newBoolean);
        Assert.assertEquals((Object)newBoolean, (Object)this.adventure.isPetsAllowed());
        Assert.assertEquals((Object)this.button.getSelection(), (Object)newBoolean);
        newBoolean = !newBoolean;
        this.button.setSelection(newBoolean);
        this.button.notifyListeners(13, null);
        Assert.assertEquals((Object)newBoolean, (Object)this.adventure.isPetsAllowed());
    }
}

