/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.databinding.scenarios;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.examples.databinding.model.Account;
import org.eclipse.jface.examples.databinding.model.Adventure;
import org.eclipse.jface.examples.databinding.model.Catalog;
import org.eclipse.jface.examples.databinding.model.Lodging;
import org.eclipse.jface.examples.databinding.model.SampleData;
import org.eclipse.jface.tests.databinding.scenarios.ScenariosTestCase;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ComboScenarios
extends ScenariosTestCase {
    protected ComboViewer cviewer = null;
    protected Combo combo = null;
    protected Catalog catalog = null;
    ILabelProvider lodgingLabelProvider = new LabelProvider(){

        public String getText(Object element) {
            return ((Lodging)element).getName();
        }
    };
    ILabelProvider accountLabelProvider = new LabelProvider(){

        public String getText(Object element) {
            return ((Account)element).getCountry();
        }
    };

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.getComposite().setLayout((Layout)new FillLayout());
        this.combo = new Combo(this.getComposite(), 12);
        this.cviewer = new ComboViewer(this.combo);
        this.catalog = SampleData.CATALOG_2005;
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.combo.dispose();
        this.combo = null;
        this.cviewer = null;
        super.tearDown();
    }

    protected Object getViewerSelection() {
        return this.cviewer.getStructuredSelection().getFirstElement();
    }

    protected List<Object> getViewerContent(ComboViewer cviewer) {
        Object[] elements = ((IStructuredContentProvider)cviewer.getContentProvider()).getElements(null);
        if (elements != null) {
            return Arrays.asList(elements);
        }
        return null;
    }

    protected List<String> getComboContent() {
        String[] elements = this.combo.getItems();
        if (elements != null) {
            return Arrays.asList(elements);
        }
        return null;
    }

    protected List<Object> getColumn(Object[] list, String feature) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (list == null || list.length == 0) {
            return result;
        }
        String getterName = "get" + feature.substring(0, 1).toUpperCase(Locale.ENGLISH) + feature.substring(1);
        try {
            Method getter = list[0].getClass().getMethod(getterName, new Class[0]);
            try {
                Object[] objectArray = list;
                int n = list.length;
                int n2 = 0;
                while (n2 < n) {
                    Object l = objectArray[n2];
                    result.add(getter.invoke(l, new Object[0]));
                    ++n2;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {}
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        return result;
    }

    @Test
    public void test_ROCombo_Scenario03_vanilla() {
        IObservableList lodgings = BeanProperties.list(Catalog.class, (String)"lodgings", Lodging.class).observe(Realm.getDefault(), (Object)this.catalog);
        ViewerSupport.bind((StructuredViewer)this.cviewer, (IObservableList)lodgings, (IValueProperty)BeanProperties.value(Lodging.class, (String)"name"));
        Adventure skiAdventure = SampleData.WINTER_HOLIDAY;
        Assert.assertArrayEquals((Object[])this.catalog.getLodgings(), (Object[])this.getViewerContent(this.cviewer).toArray());
        Assert.assertEquals(this.getColumn(this.catalog.getLodgings(), "name"), this.getComboContent());
        this.getDbc().bindValue((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)this.cviewer), BeanProperties.value((String)"defaultLodging").observe((Object)skiAdventure));
        Assert.assertEquals((Object)this.getViewerSelection(), (Object)skiAdventure.getDefaultLodging());
        int i = 0;
        while (i < this.catalog.getLodgings().length) {
            Lodging selection = this.catalog.getLodgings()[i];
            this.cviewer.setSelection((ISelection)new StructuredSelection((Object)selection));
            Assert.assertEquals((Object)selection, (Object)skiAdventure.getDefaultLodging());
            Assert.assertEquals((Object)this.getViewerSelection(), (Object)skiAdventure.getDefaultLodging());
            ++i;
        }
    }

    @Test
    public void test_ROCombo_Scenario03_collectionBindings() {
        IObservableList lodgings = BeanProperties.list((String)"lodgings").observe(Realm.getDefault(), (Object)this.catalog);
        ViewerSupport.bind((StructuredViewer)this.cviewer, (IObservableList)lodgings, (IValueProperty)BeanProperties.value(Lodging.class, (String)"name"));
        Assert.assertArrayEquals((Object[])this.catalog.getLodgings(), (Object[])this.getViewerContent(this.cviewer).toArray());
        Assert.assertEquals(this.getColumn(this.catalog.getLodgings(), "name"), this.getComboContent());
        Lodging lodging = SampleData.FACTORY.createLodging();
        lodging.setName("End Lodging");
        this.catalog.addLodging(lodging);
        int index = this.getComboContent().size() - 1;
        Assert.assertEquals((Object)this.getViewerContent(this.cviewer).get(index), (Object)lodging);
        this.catalog.removeLodging(this.catalog.getLodgings()[0]);
        Assert.assertEquals(this.getColumn(this.catalog.getLodgings(), "name"), this.getComboContent());
        this.catalog.removeLodging(this.catalog.getLodgings()[2]);
        Assert.assertEquals(this.getColumn(this.catalog.getLodgings(), "name"), this.getComboContent());
        int i = 0;
        while (i < this.catalog.getLodgings().length) {
            Lodging l = this.catalog.getLodgings()[i];
            l.setName("Changed: " + l.getName());
            ++i;
        }
        this.spinEventLoop(0);
        Assert.assertEquals(this.getColumn(this.catalog.getLodgings(), "name"), this.getComboContent());
        Lodging l = this.catalog.getLodgings()[0];
        Assert.assertEquals((Object)this.combo.getItem(0), (Object)l.getName());
        l.setName(null);
        Assert.assertEquals((Object)"", (Object)this.combo.getItem(0));
        while (this.catalog.getLodgings().length > 0) {
            this.catalog.removeLodging(this.catalog.getLodgings()[0]);
            Assert.assertEquals(this.getColumn(this.catalog.getLodgings(), "name"), this.getComboContent());
        }
    }

    @Test
    public void test_ROCombo_multipleBindings() {
        Adventure skiAdventure = SampleData.WINTER_HOLIDAY;
        IObservableList lodgings = BeanProperties.list((String)"lodgings").observe(Realm.getDefault(), (Object)this.catalog);
        ViewerSupport.bind((StructuredViewer)this.cviewer, (IObservableList)lodgings, (IValueProperty)BeanProperties.value(Lodging.class, (String)"name"));
        Assert.assertArrayEquals((Object[])this.catalog.getLodgings(), (Object[])this.getViewerContent(this.cviewer).toArray());
        Assert.assertEquals(this.getColumn(this.catalog.getLodgings(), "name"), this.getComboContent());
        ComboViewer otherViewer = new ComboViewer(this.getComposite(), 0);
        ViewerSupport.bind((StructuredViewer)otherViewer, (IObservableList)lodgings, (IValueProperty)BeanProperties.value(Lodging.class, (String)"name"));
        Assert.assertArrayEquals((Object[])this.catalog.getLodgings(), (Object[])this.getViewerContent(otherViewer).toArray());
        IViewerObservableValue selection = ViewerProperties.singleSelection().observe((Viewer)this.cviewer);
        this.getDbc().bindValue((IObservableValue)selection, BeanProperties.value((String)"defaultLodging").observe((Object)skiAdventure));
        IViewerObservableValue otherSelection = ViewerProperties.singleSelection().observe((Viewer)otherViewer);
        this.getDbc().bindValue((IObservableValue)otherSelection, BeanProperties.value((String)"defaultLodging").observe((Object)skiAdventure));
        Lodging lodging = this.catalog.getLodgings()[0];
        this.cviewer.setSelection((ISelection)new StructuredSelection((Object)lodging));
        Assert.assertEquals((Object)this.cviewer.getStructuredSelection().getFirstElement(), (Object)otherViewer.getStructuredSelection().getFirstElement());
        this.catalog.removeLodging(lodging);
        Assert.assertEquals(this.getViewerContent(this.cviewer), this.getViewerContent(otherViewer));
    }

    @Test
    public void test_ROCombo_SWTCCombo() {
        WritableList list = new WritableList();
        int i = 0;
        while (i < this.catalog.getAccounts().length) {
            list.add((Object)this.catalog.getAccounts()[i].getCountry());
            ++i;
        }
        CCombo ccombo = new CCombo(this.getComposite(), 12);
        this.getDbc().bindList((IObservableList)WidgetProperties.items().observe((Widget)ccombo), (IObservableList)list);
        Assert.assertEquals(Arrays.asList(ccombo.getItems()), (Object)list);
        Account account = this.catalog.getAccounts()[0];
        ISWTObservableValue comboSelection = WidgetProperties.ccomboSelection().observe((Widget)ccombo);
        this.getDbc().bindValue((IObservableValue)comboSelection, BeanProperties.value((String)"country").observe((Object)account));
        String selection = (String)list.get(2);
        ccombo.setText(selection);
        Assert.assertEquals((Object)account.getCountry(), (Object)selection);
    }

    @Test
    public void test_WCombo_SWTCCombo() {
        WritableList list = new WritableList();
        int i = 0;
        while (i < this.catalog.getAccounts().length) {
            list.add((Object)this.catalog.getAccounts()[i].getCountry());
            ++i;
        }
        CCombo ccombo = new CCombo(this.getComposite(), 12);
        this.getDbc().bindList((IObservableList)WidgetProperties.items().observe((Widget)ccombo), (IObservableList)list);
        Assert.assertEquals(Arrays.asList(ccombo.getItems()), (Object)list);
        Account account = this.catalog.getAccounts()[0];
        ISWTObservableValue comboSelection = WidgetProperties.ccomboSelection().observe((Widget)ccombo);
        this.getDbc().bindValue((IObservableValue)comboSelection, BeanProperties.value((String)"country").observe((Object)account));
        String selection = (String)list.get(2);
        ccombo.setText(selection);
        Assert.assertEquals((Object)account.getCountry(), (Object)selection);
        selection = (String)list.get(1);
        account.setCountry(selection);
        Assert.assertEquals((Object)selection, (Object)ccombo.getItem(ccombo.getSelectionIndex()));
        Assert.assertEquals((Object)selection, (Object)ccombo.getText());
        selection = "country not in list";
        account.setCountry(selection);
        Assert.assertEquals((long)-1L, (long)ccombo.getSelectionIndex());
        Assert.assertEquals((Object)selection, (Object)ccombo.getText());
    }

    @Test
    public void test_ROCombo_SWTList() {
        WritableList list = new WritableList();
        int i = 0;
        while (i < this.catalog.getAccounts().length) {
            list.add((Object)this.catalog.getAccounts()[i].getCountry());
            ++i;
        }
        org.eclipse.swt.widgets.List swtlist = new org.eclipse.swt.widgets.List(this.getComposite(), 12);
        this.getDbc().bindList((IObservableList)WidgetProperties.items().observe((Widget)swtlist), (IObservableList)list);
        Assert.assertEquals(Arrays.asList(swtlist.getItems()), (Object)list);
        Account account = this.catalog.getAccounts()[0];
        ISWTObservableValue listSelection = WidgetProperties.listSelection().observe((Widget)swtlist);
        this.getDbc().bindValue((IObservableValue)listSelection, BeanProperties.value((String)"country").observe((Object)account));
        String selection = (String)list.get(2);
        swtlist.select(2);
        swtlist.notifyListeners(13, null);
        Assert.assertEquals((Object)account.getCountry(), (Object)selection);
    }
}

