/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.databinding.scenarios;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.tests.databinding.scenarios.ScenariosTestCase;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class ComboUpdatingTest
extends ScenariosTestCase {
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Combo comboEditable;
    private static final String PROP_TEXT = "text";
    private String text = "Hello, world";
    private static final String PROP_CHOICES = "choices";
    private List<String> choices = new ArrayList<String>();
    private static final String NEXT = "Next";

    public ComboUpdatingTest() {
        this.choices.add("Banana");
        this.choices.add("Apple");
        this.choices.add("Mango");
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public List<String> getChoices() {
        return this.choices;
    }

    public void setChoices(List<String> choices) {
        this.choices = choices;
        this.firePropertyChange(PROP_CHOICES, null, null);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.getComposite().setLayout((Layout)new FillLayout());
        this.comboEditable = new Combo(this.getComposite(), 4);
    }

    @Test
    public void testBindText() throws Exception {
        this.getDbc().bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.comboEditable), BeanProperties.value(ComboUpdatingTest.class, (String)PROP_TEXT).observe((Object)this));
        this.spinEventLoop(0);
        Assert.assertEquals((String)"Should find value of text", (Object)this.text, (Object)this.comboEditable.getText());
        this.comboEditable.setText(NEXT);
        this.spinEventLoop(0);
        Assert.assertEquals((String)"Should find new value in text", (Object)NEXT, (Object)this.text);
    }

    @Test
    @Ignore
    public void testBindItems_listHasSameItems_editable() throws Exception {
        this.text = "Apple";
        this.getDbc().bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.comboEditable), BeanProperties.value(ComboUpdatingTest.class, (String)PROP_TEXT).observe((Object)this));
        this.spinEventLoop(0);
        Assert.assertEquals((String)"Should find value of text", (Object)this.text, (Object)this.comboEditable.getText());
        WritableList list = new WritableList(this.getChoices(), null);
        this.getDbc().bindList((IObservableList)WidgetProperties.items().observe((Widget)this.comboEditable), (IObservableList)list);
        this.spinEventLoop(0);
        int position = 0;
        for (String element : this.choices) {
            Assert.assertEquals((Object)element, (Object)this.comboEditable.getItem(position));
            ++position;
        }
        Assert.assertEquals((String)"Should find value of combo.getText()", (Object)"", (Object)this.comboEditable.getText());
        this.comboEditable.setText("Banana");
        this.spinEventLoop(0);
        Assert.assertEquals((String)"Should find value of text", (Object)"Banana", (Object)this.text);
    }

    @Test
    @Ignore
    public void testBindItems_listHasDifferentItems_editable() throws Exception {
        this.getDbc().bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.comboEditable), BeanProperties.value(ComboUpdatingTest.class, (String)PROP_TEXT).observe((Object)this));
        this.spinEventLoop(0);
        Assert.assertEquals((String)"Should find value of text", (Object)this.text, (Object)this.comboEditable.getText());
        WritableList list = new WritableList(new ArrayList(), String.class);
        list.addAll(this.getChoices());
        this.getDbc().bindList((IObservableList)WidgetProperties.items().observe((Widget)this.comboEditable), (IObservableList)list);
        this.spinEventLoop(0);
        int position = 0;
        for (String element : this.choices) {
            Assert.assertEquals((Object)element, (Object)this.comboEditable.getItem(position));
            ++position;
        }
        Assert.assertEquals((String)"Should find value of combo.getText()", (Object)"", (Object)this.comboEditable.getText());
        this.comboEditable.setText("Banana");
        this.spinEventLoop(0);
        Assert.assertEquals((String)"Should find value of text", (Object)"Banana", (Object)this.text);
    }
}

