/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.databinding.scenarios;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.examples.databinding.model.Adventure;
import org.eclipse.jface.examples.databinding.model.PriceModelObject;
import org.eclipse.jface.examples.databinding.model.SampleData;
import org.eclipse.jface.tests.databinding.scenarios.ScenariosTestCase;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CustomConverterScenarios
extends ScenariosTestCase {
    private Adventure skiTrip;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.skiTrip = SampleData.WINTER_HOLIDAY;
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testScenario01() {
        DataBindingContext dbc = this.getDbc();
        Spinner spinner_dollars = new Spinner(this.getComposite(), 0);
        spinner_dollars.setMaximum(10000);
        Spinner spinner_cents = new Spinner(this.getComposite(), 0);
        PriceModelObject priceModel = new PriceModelObject();
        dbc.bindValue(BeanProperties.value((String)"price").observe((Object)priceModel), BeanProperties.value((String)"price").observe((Object)this.skiTrip));
        dbc.bindValue((IObservableValue)WidgetProperties.spinnerSelection().observe((Widget)spinner_dollars), BeanProperties.value((String)"dollars").observe((Object)priceModel));
        dbc.bindValue((IObservableValue)WidgetProperties.spinnerSelection().observe((Widget)spinner_cents), BeanProperties.value((String)"cents").observe((Object)priceModel));
        Assert.assertEquals((long)spinner_dollars.getSelection(), (long)Double.valueOf(this.skiTrip.getPrice()).intValue());
        Double doublePrice = this.skiTrip.getPrice();
        double cents = 100.0 * doublePrice - (double)(100 * doublePrice.intValue());
        Assert.assertEquals((long)spinner_cents.getSelection(), (long)((int)cents));
        spinner_dollars.setSelection(50);
        double expectedPrice = 50.0 + cents / 100.0;
        Assert.assertEquals((double)expectedPrice, (double)this.skiTrip.getPrice(), (double)0.01);
        spinner_cents.setSelection(27);
        Assert.assertEquals((double)50.27, (double)this.skiTrip.getPrice(), (double)0.01);
        this.skiTrip.setPrice(60.99);
        Assert.assertEquals((long)60L, (long)spinner_dollars.getSelection());
        Assert.assertEquals((long)99L, (long)spinner_cents.getSelection());
    }
}

