/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.databinding.scenarios;

import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.examples.databinding.model.Adventure;
import org.eclipse.jface.examples.databinding.model.Catalog;
import org.eclipse.jface.examples.databinding.model.Lodging;
import org.eclipse.jface.examples.databinding.model.SampleData;
import org.eclipse.jface.tests.databinding.scenarios.ScenariosTestCase;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ListViewerScenario
extends ScenariosTestCase {
    private Catalog catalog;
    private List list;
    private ListViewer listViewer;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.list = new List(this.getComposite(), 12);
        this.listViewer = new ListViewer(this.list);
        this.catalog = SampleData.CATALOG_2005;
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.list.dispose();
        this.list = null;
        this.listViewer = null;
        super.tearDown();
    }

    @Test
    public void testScenario01() {
        IObservableList lodgings = BeanProperties.list((String)"lodgings").observe((Object)this.catalog);
        ViewerSupport.bind((StructuredViewer)this.listViewer, (IObservableList)lodgings, (IValueProperty)BeanProperties.value(Lodging.class, (String)"name"));
        int i = 0;
        while (i < this.catalog.getLodgings().length) {
            Assert.assertEquals((Object)this.catalog.getLodgings()[i], (Object)this.listViewer.getElementAt(i));
            ++i;
        }
        Object[] lodgingStrings = new String[this.catalog.getLodgings().length];
        int i2 = 0;
        while (i2 < this.catalog.getLodgings().length) {
            lodgingStrings[i2] = this.catalog.getLodgings()[i2].getName();
            ++i2;
        }
        Assert.assertArrayEquals((Object[])lodgingStrings, (Object[])this.list.getItems());
        Assert.assertEquals(null, (Object)this.listViewer.getStructuredSelection().getFirstElement());
        Adventure adventure = SampleData.WINTER_HOLIDAY;
        IViewerObservableValue selection = ViewerProperties.singleSelection().observe((Viewer)this.listViewer);
        this.getDbc().bindValue((IObservableValue)selection, BeanProperties.value((String)"defaultLodging").observe((Object)adventure));
        Assert.assertEquals((Object)this.listViewer.getStructuredSelection().getFirstElement(), (Object)adventure.getDefaultLodging());
        adventure.setDefaultLodging(SampleData.CAMP_GROUND);
        Assert.assertEquals((Object)adventure.getDefaultLodging(), (Object)SampleData.CAMP_GROUND);
        Assert.assertEquals((Object)this.listViewer.getStructuredSelection().getFirstElement(), (Object)adventure.getDefaultLodging());
        this.listViewer.getList().select(3);
        Assert.assertEquals((Object)this.listViewer.getStructuredSelection().getFirstElement(), (Object)adventure.getDefaultLodging());
        adventure.setDefaultLodging(SampleData.YOUTH_HOSTEL);
        this.spinEventLoop(0);
        Assert.assertEquals((Object)this.listViewer.getStructuredSelection().getFirstElement(), (Object)adventure.getDefaultLodging());
    }
}

